/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutSetPrototypeSoap;
import com.liferay.portal.kernel.service.LayoutSetPrototypeServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutSetPrototypeServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeServiceSoap.class);

    public static LayoutSetPrototypeSoap addLayoutSetPrototype(String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            LayoutSetPrototype returnValue = LayoutSetPrototypeServiceUtil.addLayoutSetPrototype(nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
            return LayoutSetPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayoutSetPrototype(long layoutSetPrototypeId) throws RemoteException {
        try {
            LayoutSetPrototypeServiceUtil.deleteLayoutSetPrototype(layoutSetPrototypeId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetPrototypeSoap fetchLayoutSetPrototype(long layoutSetPrototypeId) throws RemoteException {
        try {
            LayoutSetPrototype returnValue = LayoutSetPrototypeServiceUtil.fetchLayoutSetPrototype(layoutSetPrototypeId);
            return LayoutSetPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetPrototypeSoap getLayoutSetPrototype(long layoutSetPrototypeId) throws RemoteException {
        try {
            LayoutSetPrototype returnValue = LayoutSetPrototypeServiceUtil.getLayoutSetPrototype(layoutSetPrototypeId);
            return LayoutSetPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetPrototypeSoap[] search(long companyId, Boolean active, OrderByComparator<LayoutSetPrototype> obc) throws RemoteException {
        try {
            List<LayoutSetPrototype> returnValue = LayoutSetPrototypeServiceUtil.search(companyId, active, obc);
            return LayoutSetPrototypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetPrototypeSoap updateLayoutSetPrototype(long layoutSetPrototypeId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            LayoutSetPrototype returnValue = LayoutSetPrototypeServiceUtil.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, descriptionMap, active, layoutsUpdateable, serviceContext);
            return LayoutSetPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetPrototypeSoap updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws RemoteException {
        try {
            LayoutSetPrototype returnValue = LayoutSetPrototypeServiceUtil.updateLayoutSetPrototype(layoutSetPrototypeId, settings);
            return LayoutSetPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

