/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetBranchSoap;
import com.liferay.portal.kernel.service.LayoutSetBranchServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutSetBranchServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetBranchServiceSoap.class);

    public static LayoutSetBranchSoap addLayoutSetBranch(long groupId, boolean privateLayout, String name, String description, boolean master, long copyLayoutSetBranchId, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutSetBranch returnValue = LayoutSetBranchServiceUtil.addLayoutSetBranch(groupId, privateLayout, name, description, master, copyLayoutSetBranchId, serviceContext);
            return LayoutSetBranchSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayoutSetBranch(long layoutSetBranchId) throws RemoteException {
        try {
            LayoutSetBranchServiceUtil.deleteLayoutSetBranch(layoutSetBranchId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetBranchSoap[] getLayoutSetBranches(long groupId, boolean privateLayout) throws RemoteException {
        try {
            List<LayoutSetBranch> returnValue = LayoutSetBranchServiceUtil.getLayoutSetBranches(groupId, privateLayout);
            return LayoutSetBranchSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetBranchSoap mergeLayoutSetBranch(long layoutSetBranchId, long mergeLayoutSetBranchId, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutSetBranch returnValue = LayoutSetBranchServiceUtil.mergeLayoutSetBranch(layoutSetBranchId, mergeLayoutSetBranchId, serviceContext);
            return LayoutSetBranchSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSetBranchSoap updateLayoutSetBranch(long groupId, long layoutSetBranchId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutSetBranch returnValue = LayoutSetBranchServiceUtil.updateLayoutSetBranch(groupId, layoutSetBranchId, name, description, serviceContext);
            return LayoutSetBranchSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

