/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.LayoutSetBranchServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutSetBranchServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetBranchServiceHttp.class);
    private static final Class<?>[] _addLayoutSetBranchParameterTypes0 = new Class[]{Long.TYPE, Boolean.TYPE, String.class, String.class, Boolean.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteLayoutSetBranchParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getLayoutSetBranchesParameterTypes2 = new Class[]{Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _mergeLayoutSetBranchParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _updateLayoutSetBranchParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, ServiceContext.class};

    public static LayoutSetBranch addLayoutSetBranch(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, String name, String description, boolean master, long copyLayoutSetBranchId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetBranchServiceUtil.class, "addLayoutSetBranch", _addLayoutSetBranchParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, privateLayout, name, description, master, copyLayoutSetBranchId, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutSetBranch)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteLayoutSetBranch(HttpPrincipal httpPrincipal, long layoutSetBranchId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetBranchServiceUtil.class, "deleteLayoutSetBranch", _deleteLayoutSetBranchParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutSetBranchId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<LayoutSetBranch> getLayoutSetBranches(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout) {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetBranchServiceUtil.class, "getLayoutSetBranches", _getLayoutSetBranchesParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, privateLayout);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static LayoutSetBranch mergeLayoutSetBranch(HttpPrincipal httpPrincipal, long layoutSetBranchId, long mergeLayoutSetBranchId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetBranchServiceUtil.class, "mergeLayoutSetBranch", _mergeLayoutSetBranchParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutSetBranchId, mergeLayoutSetBranchId, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutSetBranch)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static LayoutSetBranch updateLayoutSetBranch(HttpPrincipal httpPrincipal, long groupId, long layoutSetBranchId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetBranchServiceUtil.class, "updateLayoutSetBranch", _updateLayoutSetBranchParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, layoutSetBranchId, name, description, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutSetBranch)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

