/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSoap;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutServiceSoap.class);

    public static LayoutSoap addLayout(long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, String[] localeNamesMapLanguageIds, String[] localeNamesMapValues, String[] localeTitlesMapLanguageIds, String[] localeTitlesMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String[] keywordsMapLanguageIds, String[] keywordsMapValues, String[] robotsMapLanguageIds, String[] robotsMapValues, String type, String typeSettings, boolean hidden, boolean system, String[] friendlyURLMapLanguageIds, String[] friendlyURLMapValues, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> localeNamesMap = LocalizationUtil.getLocalizationMap(localeNamesMapLanguageIds, localeNamesMapValues);
            Map<Locale, String> localeTitlesMap = LocalizationUtil.getLocalizationMap(localeTitlesMapLanguageIds, localeTitlesMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Map<Locale, String> keywordsMap = LocalizationUtil.getLocalizationMap(keywordsMapLanguageIds, keywordsMapValues);
            Map<Locale, String> robotsMap = LocalizationUtil.getLocalizationMap(robotsMapLanguageIds, robotsMapValues);
            Map<Locale, String> friendlyURLMap = LocalizationUtil.getLocalizationMap(friendlyURLMapLanguageIds, friendlyURLMapValues);
            Layout returnValue = LayoutServiceUtil.addLayout(groupId, privateLayout, parentLayoutId, classNameId, classPK, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, serviceContext);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap addLayout(long groupId, boolean privateLayout, long parentLayoutId, String[] localeNamesMapLanguageIds, String[] localeNamesMapValues, String[] localeTitlesMapLanguageIds, String[] localeTitlesMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String[] keywordsMapLanguageIds, String[] keywordsMapValues, String[] robotsMapLanguageIds, String[] robotsMapValues, String type, String typeSettings, boolean hidden, String[] friendlyURLMapLanguageIds, String[] friendlyURLMapValues, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> localeNamesMap = LocalizationUtil.getLocalizationMap(localeNamesMapLanguageIds, localeNamesMapValues);
            Map<Locale, String> localeTitlesMap = LocalizationUtil.getLocalizationMap(localeTitlesMapLanguageIds, localeTitlesMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Map<Locale, String> keywordsMap = LocalizationUtil.getLocalizationMap(keywordsMapLanguageIds, keywordsMapValues);
            Map<Locale, String> robotsMap = LocalizationUtil.getLocalizationMap(robotsMapLanguageIds, robotsMapValues);
            Map<Locale, String> friendlyURLMap = LocalizationUtil.getLocalizationMap(friendlyURLMapLanguageIds, friendlyURLMapValues);
            Layout returnValue = LayoutServiceUtil.addLayout(groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, friendlyURLMap, serviceContext);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.addLayout(groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutServiceUtil.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayout(long plid, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutServiceUtil.deleteLayout(plid, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTempFileEntry(long groupId, String folderName, String fileName) throws RemoteException {
        try {
            LayoutServiceUtil.deleteTempFileEntry(groupId, folderName, fileName);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getAncestorLayouts(long plid) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getAncestorLayouts(plid);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getControlPanelLayoutPlid() throws RemoteException {
        try {
            long returnValue = LayoutServiceUtil.getControlPanelLayoutPlid();
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getDefaultPlid(long groupId, boolean privateLayout) throws RemoteException {
        try {
            long returnValue = LayoutServiceUtil.getDefaultPlid(groupId, privateLayout);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws RemoteException {
        try {
            long returnValue = LayoutServiceUtil.getDefaultPlid(groupId, scopeGroupId, privateLayout, portletId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws RemoteException {
        try {
            long returnValue = LayoutServiceUtil.getDefaultPlid(groupId, scopeGroupId, portletId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws RemoteException {
        try {
            String returnValue = LayoutServiceUtil.getLayoutName(groupId, privateLayout, layoutId, languageId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static long getLayoutPlid(String uuid, long groupId, boolean privateLayout) throws RemoteException {
        try {
            long returnValue = LayoutServiceUtil.getLayoutPlid(uuid, groupId, privateLayout);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) throws RemoteException {
        try {
            LayoutReference[] returnValue = LayoutServiceUtil.getLayoutReferences(companyId, portletId, preferencesKey, preferencesValue);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getLayouts(long groupId, boolean privateLayout) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getLayouts(groupId, privateLayout);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getLayouts(groupId, privateLayout, parentLayoutId);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getLayouts(long groupId, String type) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getLayouts(groupId, type);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap[] getLayouts(long groupId, String type, int start, int end) throws RemoteException {
        try {
            List<Layout> returnValue = LayoutServiceUtil.getLayouts(groupId, type, start, end);
            return LayoutSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getLayoutsCount(long groupId, boolean privateLayout) throws RemoteException {
        try {
            int returnValue = LayoutServiceUtil.getLayoutsCount(groupId, privateLayout);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) throws RemoteException {
        try {
            int returnValue = LayoutServiceUtil.getLayoutsCount(groupId, privateLayout, parentLayoutId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId, int priority) throws RemoteException {
        try {
            int returnValue = LayoutServiceUtil.getLayoutsCount(groupId, privateLayout, parentLayoutId, priority);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getLayoutsCount(long groupId, String type) throws RemoteException {
        try {
            int returnValue = LayoutServiceUtil.getLayoutsCount(groupId, type);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String[] getTempFileNames(long groupId, String folderName) throws RemoteException {
        try {
            String[] returnValue = LayoutServiceUtil.getTempFileNames(groupId, folderName);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws RemoteException {
        try {
            boolean returnValue = LayoutServiceUtil.hasLayout(uuid, groupId, privateLayout);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasPortletId(long plid, String portletId) throws RemoteException {
        try {
            boolean returnValue = LayoutServiceUtil.hasPortletId(plid, portletId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutServiceUtil.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unschedulePublishToLive(long groupId, String jobName, String groupName) throws RemoteException {
        try {
            LayoutServiceUtil.unschedulePublishToLive(groupId, jobName, groupName);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws RemoteException {
        try {
            LayoutServiceUtil.unschedulePublishToRemote(groupId, jobName, groupName);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateIconImage(long plid, byte[] bytes) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateIconImage(plid, bytes);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String[] localeNamesMapLanguageIds, String[] localeNamesMapValues, String[] localeTitlesMapLanguageIds, String[] localeTitlesMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String[] keywordsMapLanguageIds, String[] keywordsMapValues, String[] robotsMapLanguageIds, String[] robotsMapValues, String type, boolean hidden, String[] friendlyURLMapLanguageIds, String[] friendlyURLMapValues, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> localeNamesMap = LocalizationUtil.getLocalizationMap(localeNamesMapLanguageIds, localeNamesMapValues);
            Map<Locale, String> localeTitlesMap = LocalizationUtil.getLocalizationMap(localeTitlesMapLanguageIds, localeTitlesMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Map<Locale, String> keywordsMap = LocalizationUtil.getLocalizationMap(keywordsMapLanguageIds, keywordsMapValues);
            Map<Locale, String> robotsMap = LocalizationUtil.getLocalizationMap(robotsMapLanguageIds, robotsMapValues);
            Map<Locale, String> friendlyURLMap = LocalizationUtil.getLocalizationMap(friendlyURLMapLanguageIds, friendlyURLMapValues);
            Layout returnValue = LayoutServiceUtil.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateLayout(groupId, privateLayout, layoutId, typeSettings);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateName(groupId, privateLayout, layoutId, name, languageId);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateName(long plid, String name, String languageId) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateName(plid, name, languageId);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateParentLayoutId(long plid, long parentPlid) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateParentLayoutId(plid, parentPlid);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updatePriority(groupId, privateLayout, layoutId, priority);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutSoap updatePriority(long plid, int priority) throws RemoteException {
        try {
            Layout returnValue = LayoutServiceUtil.updatePriority(plid, priority);
            return LayoutSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

