/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutPrototypeSoap;
import com.liferay.portal.kernel.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutPrototypeServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutPrototypeServiceSoap.class);

    public static LayoutPrototypeSoap addLayoutPrototype(String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            LayoutPrototype returnValue = LayoutPrototypeServiceUtil.addLayoutPrototype(nameMap, descriptionMap, active, serviceContext);
            return LayoutPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayoutPrototype(long layoutPrototypeId) throws RemoteException {
        try {
            LayoutPrototypeServiceUtil.deleteLayoutPrototype(layoutPrototypeId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutPrototypeSoap fetchLayoutPrototype(long layoutPrototypeId) throws RemoteException {
        try {
            LayoutPrototype returnValue = LayoutPrototypeServiceUtil.fetchLayoutPrototype(layoutPrototypeId);
            return LayoutPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutPrototypeSoap getLayoutPrototype(long layoutPrototypeId) throws RemoteException {
        try {
            LayoutPrototype returnValue = LayoutPrototypeServiceUtil.getLayoutPrototype(layoutPrototypeId);
            return LayoutPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutPrototypeSoap[] search(long companyId, Boolean active, OrderByComparator<LayoutPrototype> obc) throws RemoteException {
        try {
            List<LayoutPrototype> returnValue = LayoutPrototypeServiceUtil.search(companyId, active, obc);
            return LayoutPrototypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutPrototypeSoap updateLayoutPrototype(long layoutPrototypeId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            LayoutPrototype returnValue = LayoutPrototypeServiceUtil.updateLayoutPrototype(layoutPrototypeId, nameMap, descriptionMap, active, serviceContext);
            return LayoutPrototypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

