/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutPrototypeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutPrototypeServiceHttp.class);
    private static final Class<?>[] _addLayoutPrototypeParameterTypes0 = new Class[]{Map.class, Map.class, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteLayoutPrototypeParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchLayoutPrototypeParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getLayoutPrototypeParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _searchParameterTypes4 = new Class[]{Long.TYPE, Boolean.class, OrderByComparator.class};
    private static final Class<?>[] _updateLayoutPrototypeParameterTypes5 = new Class[]{Long.TYPE, Map.class, Map.class, Boolean.TYPE, ServiceContext.class};

    public static LayoutPrototype addLayoutPrototype(HttpPrincipal httpPrincipal, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "addLayoutPrototype", _addLayoutPrototypeParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, nameMap, descriptionMap, active, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "deleteLayoutPrototype", _deleteLayoutPrototypeParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutPrototypeId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static LayoutPrototype fetchLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "fetchLayoutPrototype", _fetchLayoutPrototypeParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutPrototypeId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static LayoutPrototype getLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "getLayoutPrototype", _getLayoutPrototypeParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutPrototypeId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<LayoutPrototype> search(HttpPrincipal httpPrincipal, long companyId, Boolean active, OrderByComparator<LayoutPrototype> obc) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "search", _searchParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, active, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static LayoutPrototype updateLayoutPrototype(HttpPrincipal httpPrincipal, long layoutPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(LayoutPrototypeServiceUtil.class, "updateLayoutPrototype", _updateLayoutPrototypeParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, layoutPrototypeId, nameMap, descriptionMap, active, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (LayoutPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

