/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutBranchSoap;
import com.liferay.portal.kernel.service.LayoutBranchServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class LayoutBranchServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(LayoutBranchServiceSoap.class);

    public static LayoutBranchSoap addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutBranch returnValue = LayoutBranchServiceUtil.addLayoutBranch(layoutRevisionId, name, description, master, serviceContext);
            return LayoutBranchSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLayoutBranch(long layoutBranchId) throws RemoteException {
        try {
            LayoutBranchServiceUtil.deleteLayoutBranch(layoutBranchId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static LayoutBranchSoap updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            LayoutBranch returnValue = LayoutBranchServiceUtil.updateLayoutBranch(layoutBranchId, name, description, serviceContext);
            return LayoutBranchSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

