/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ImageServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ImageServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ImageServiceHttp.class);
    private static final Class<?>[] _getImageParameterTypes0 = new Class[]{Long.TYPE};

    public static Image getImage(HttpPrincipal httpPrincipal, long imageId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ImageServiceUtil.class, "getImage", _getImageParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, imageId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Image)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

