/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupSoap;
import com.liferay.portal.kernel.model.OrganizationSoap;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.UserGroupSoap;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.model.impl.OrganizationModelImpl;
import com.liferay.portal.model.impl.UserGroupModelImpl;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class GroupServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceSoap.class);

    public static GroupSoap addGroup(long parentGroupId, long liveGroupId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean inheritContent, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Group returnValue = GroupServiceUtil.addGroup(parentGroupId, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, inheritContent, active, serviceContext);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap addGroup(long parentGroupId, long liveGroupId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Group returnValue = GroupServiceUtil.addGroup(parentGroupId, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, active, serviceContext);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void addRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.addRoleGroups(roleId, groupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkRemoteStagingGroup(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.checkRemoteStagingGroup(groupId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteGroup(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.deleteGroup(groupId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void disableStaging(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.disableStaging(groupId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void enableStaging(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.enableStaging(groupId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap getCompanyGroup(long companyId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getCompanyGroup(companyId);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap getGroup(long groupId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getGroup(groupId);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap getGroup(long companyId, String groupKey) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getGroup(companyId, groupKey);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getGroupDisplayURL(long groupId, boolean privateLayout, boolean secureConnection) throws RemoteException {
        try {
            String returnValue = GroupServiceUtil.getGroupDisplayURL(groupId, privateLayout, secureConnection);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getGroups(long companyId, long parentGroupId, boolean site) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getGroups(companyId, parentGroupId, site);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getGroups(long companyId, long parentGroupId, boolean site, int start, int end) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getGroups(companyId, parentGroupId, site, start, end);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getGroups(long companyId, long parentGroupId, String name, boolean site, int start, int end) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getGroups(companyId, parentGroupId, name, site, start, end);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupsCount(long companyId, long parentGroupId, boolean site) throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.getGroupsCount(companyId, parentGroupId, site);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupsCount(long companyId, long parentGroupId, String name, boolean site) throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.getGroupsCount(companyId, parentGroupId, name, site);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupsCount(long companyId, String className, long parentGroupId) throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.getGroupsCount(companyId, className, parentGroupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getGtGroups(long gtGroupId, long companyId, long parentGroupId, boolean site, int size) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getGtGroups(gtGroupId, companyId, parentGroupId, site, size);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getManageableSiteGroups(Collection<Portlet> portlets, int max) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getManageableSiteGroups(portlets, max);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getOrganizationsGroups(OrganizationSoap[] organizations) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getOrganizationsGroups(OrganizationModelImpl.toModels(organizations));
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap getUserGroup(long companyId, long userId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getUserGroup(companyId, userId);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getUserGroupsGroups(UserGroupSoap[] userGroups) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getUserGroupsGroups(UserGroupModelImpl.toModels(userGroups));
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getUserOrganizationsGroups(long userId, int start, int end) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getUserOrganizationsGroups(userId, start, end);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getUserSitesGroups() throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getUserSitesGroups();
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getUserSitesGroups(long userId, String[] classNames, int max) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getUserSitesGroups(userId, classNames, max);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] getUserSitesGroups(String[] classNames, int max) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.getUserSitesGroups(classNames, max);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserSitesGroupsCount() throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.getUserSitesGroupsCount();
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserGroup(long userId, long groupId) throws RemoteException {
        try {
            boolean returnValue = GroupServiceUtil.hasUserGroup(userId, groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap[] search(long companyId, String name, String description, String[] params, int start, int end) throws RemoteException {
        try {
            List<Group> returnValue = GroupServiceUtil.search(companyId, name, description, params, start, end);
            return GroupSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int searchCount(long companyId, String name, String description, String[] params) throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.searchCount(companyId, name, description, params);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void setRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.setRoleGroups(roleId, groupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.unsetRoleGroups(roleId, groupIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap updateFriendlyURL(long groupId, String friendlyURL) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.updateFriendlyURL(groupId, friendlyURL);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap updateGroup(long groupId, long parentGroupId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            Group returnValue = GroupServiceUtil.updateGroup(groupId, parentGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static GroupSoap updateGroup(long groupId, String typeSettings) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.updateGroup(groupId, typeSettings);
            return GroupSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

