/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class GroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceHttp.class);
    private static final Class<?>[] _addGroupParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, Map.class, Map.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _addGroupParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE, Map.class, Map.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _addRoleGroupsParameterTypes2 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _checkRemoteStagingGroupParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteGroupParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _disableStagingParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _enableStagingParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyGroupParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupParameterTypes8 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupParameterTypes9 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getGroupDisplayURLParameterTypes10 = new Class[]{Long.TYPE, Boolean.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getGroupsParameterTypes11 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getGroupsParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupsParameterTypes13 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getGroupsCountParameterTypes14 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getGroupsCountParameterTypes15 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE};
    private static final Class<?>[] _getGroupsCountParameterTypes16 = new Class[]{Long.TYPE, String.class, Long.TYPE};
    private static final Class<?>[] _getGtGroupsParameterTypes17 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE};
    private static final Class<?>[] _getManageableSiteGroupsParameterTypes18 = new Class[]{Collection.class, Integer.TYPE};
    private static final Class<?>[] _getOrganizationsGroupsParameterTypes19 = new Class[]{List.class};
    private static final Class<?>[] _getUserGroupParameterTypes20 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserGroupsGroupsParameterTypes21 = new Class[]{List.class};
    private static final Class<?>[] _getUserOrganizationsGroupsParameterTypes22 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getUserSitesGroupsParameterTypes23 = new Class[0];
    private static final Class<?>[] _getUserSitesGroupsParameterTypes24 = new Class[]{Long.TYPE, String[].class, Integer.TYPE};
    private static final Class<?>[] _getUserSitesGroupsParameterTypes25 = new Class[]{String[].class, Integer.TYPE};
    private static final Class<?>[] _getUserSitesGroupsCountParameterTypes26 = new Class[0];
    private static final Class<?>[] _hasUserGroupParameterTypes27 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _searchParameterTypes28 = new Class[]{Long.TYPE, long[].class, String.class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchParameterTypes29 = new Class[]{Long.TYPE, long[].class, String.class, String.class, LinkedHashMap.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchParameterTypes30 = new Class[]{Long.TYPE, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _searchCountParameterTypes31 = new Class[]{Long.TYPE, String.class, String.class, String[].class};
    private static final Class<?>[] _setRoleGroupsParameterTypes32 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _unsetRoleGroupsParameterTypes33 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateFriendlyURLParameterTypes34 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateGroupParameterTypes35 = new Class[]{Long.TYPE, Long.TYPE, Map.class, Map.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _updateGroupParameterTypes36 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateStagedPortletsParameterTypes37 = new Class[]{Long.TYPE, Map.class};

    public static Group addGroup(HttpPrincipal httpPrincipal, long parentGroupId, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "addGroup", _addGroupParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, parentGroupId, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, inheritContent, active, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group addGroup(HttpPrincipal httpPrincipal, long parentGroupId, long liveGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "addGroup", _addGroupParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, parentGroupId, liveGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, active, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void addRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "addRoleGroups", _addRoleGroupsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId, groupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void checkRemoteStagingGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "checkRemoteStagingGroup", _checkRemoteStagingGroupParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "deleteGroup", _deleteGroupParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void disableStaging(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "disableStaging", _disableStagingParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void enableStaging(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "enableStaging", _enableStagingParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group getCompanyGroup(HttpPrincipal httpPrincipal, long companyId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getCompanyGroup", _getCompanyGroupParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroup", _getGroupParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long companyId, String groupKey) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroup", _getGroupParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, groupKey);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static String getGroupDisplayURL(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, boolean secureConnection) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroupDisplayURL", _getGroupDisplayURLParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, privateLayout, secureConnection);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getGroups(HttpPrincipal httpPrincipal, long companyId, long parentGroupId, boolean site) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroups", _getGroupsParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, parentGroupId, site);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getGroups(HttpPrincipal httpPrincipal, long companyId, long parentGroupId, boolean site, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroups", _getGroupsParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, parentGroupId, site, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getGroups(HttpPrincipal httpPrincipal, long companyId, long parentGroupId, String name, boolean site, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroups", _getGroupsParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, parentGroupId, name, site, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getGroupsCount(HttpPrincipal httpPrincipal, long companyId, long parentGroupId, boolean site) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroupsCount", _getGroupsCountParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, parentGroupId, site);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getGroupsCount(HttpPrincipal httpPrincipal, long companyId, long parentGroupId, String name, boolean site) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroupsCount", _getGroupsCountParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, parentGroupId, name, site);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getGroupsCount(HttpPrincipal httpPrincipal, long companyId, String className, long parentGroupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGroupsCount", _getGroupsCountParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, className, parentGroupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getGtGroups(HttpPrincipal httpPrincipal, long gtGroupId, long companyId, long parentGroupId, boolean site, int size) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getGtGroups", _getGtGroupsParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, gtGroupId, companyId, parentGroupId, site, size);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getManageableSiteGroups(HttpPrincipal httpPrincipal, Collection<Portlet> portlets, int max) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getManageableSiteGroups", _getManageableSiteGroupsParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, portlets, max);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getOrganizationsGroups(HttpPrincipal httpPrincipal, List<Organization> organizations) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getOrganizationsGroups", _getOrganizationsGroupsParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, organizations);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group getUserGroup(HttpPrincipal httpPrincipal, long companyId, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserGroup", _getUserGroupParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, userId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getUserGroupsGroups(HttpPrincipal httpPrincipal, List<UserGroup> userGroups) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserGroupsGroups", _getUserGroupsGroupsParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, userGroups);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getUserOrganizationsGroups(HttpPrincipal httpPrincipal, long userId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserOrganizationsGroups", _getUserOrganizationsGroupsParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getUserSitesGroups(HttpPrincipal httpPrincipal) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserSitesGroups", _getUserSitesGroupsParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getUserSitesGroups(HttpPrincipal httpPrincipal, long userId, String[] classNames, int max) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserSitesGroups", _getUserSitesGroupsParameterTypes24);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, classNames, max);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> getUserSitesGroups(HttpPrincipal httpPrincipal, String[] classNames, int max) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserSitesGroups", _getUserSitesGroupsParameterTypes25);
            MethodHandler methodHandler = new MethodHandler(methodKey, classNames, max);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getUserSitesGroupsCount(HttpPrincipal httpPrincipal) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "getUserSitesGroupsCount", _getUserSitesGroupsCountParameterTypes26);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static boolean hasUserGroup(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "hasUserGroup", _hasUserGroupParameterTypes27);
            MethodHandler methodHandler = new MethodHandler(methodKey, userId, groupId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "search", _searchParameterTypes28);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, classNameIds, keywords, params, start, end, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "search", _searchParameterTypes29);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, classNameIds, name, description, params, andOperator, start, end, obc);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "search", _searchParameterTypes30);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name, description, params, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params) {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "searchCount", _searchCountParameterTypes31);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, name, description, params);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void setRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "setRoleGroups", _setRoleGroupsParameterTypes32);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId, groupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void unsetRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "unsetRoleGroups", _unsetRoleGroupsParameterTypes33);
            MethodHandler methodHandler = new MethodHandler(methodKey, roleId, groupIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group updateFriendlyURL(HttpPrincipal httpPrincipal, long groupId, String friendlyURL) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "updateFriendlyURL", _updateFriendlyURLParameterTypes34);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, friendlyURL);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, long parentGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean inheritContent, boolean active, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "updateGroup", _updateGroupParameterTypes35);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, parentGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String typeSettings) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "updateGroup", _updateGroupParameterTypes36);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, typeSettings);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void updateStagedPortlets(HttpPrincipal httpPrincipal, long groupId, Map<String, String> stagedPortletIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class, "updateStagedPortlets", _updateStagedPortletsParameterTypes37);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, stagedPortletIds);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

