/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.EmailAddressSoap;
import com.liferay.portal.kernel.service.EmailAddressServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class EmailAddressServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(EmailAddressServiceSoap.class);

    public static EmailAddressSoap addEmailAddress(String className, long classPK, String address, long typeId, boolean primary, ServiceContext serviceContext) throws RemoteException {
        try {
            EmailAddress returnValue = EmailAddressServiceUtil.addEmailAddress(className, classPK, address, typeId, primary, serviceContext);
            return EmailAddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteEmailAddress(long emailAddressId) throws RemoteException {
        try {
            EmailAddressServiceUtil.deleteEmailAddress(emailAddressId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static EmailAddressSoap fetchEmailAddress(long emailAddressId) throws RemoteException {
        try {
            EmailAddress returnValue = EmailAddressServiceUtil.fetchEmailAddress(emailAddressId);
            return EmailAddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static EmailAddressSoap getEmailAddress(long emailAddressId) throws RemoteException {
        try {
            EmailAddress returnValue = EmailAddressServiceUtil.getEmailAddress(emailAddressId);
            return EmailAddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static EmailAddressSoap[] getEmailAddresses(String className, long classPK) throws RemoteException {
        try {
            List<EmailAddress> returnValue = EmailAddressServiceUtil.getEmailAddresses(className, classPK);
            return EmailAddressSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static EmailAddressSoap updateEmailAddress(long emailAddressId, String address, long typeId, boolean primary) throws RemoteException {
        try {
            EmailAddress returnValue = EmailAddressServiceUtil.updateEmailAddress(emailAddressId, address, typeId, primary);
            return EmailAddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

