/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.EmailAddressServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class EmailAddressServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(EmailAddressServiceHttp.class);
    private static final Class<?>[] _addEmailAddressParameterTypes0 = new Class[]{String.class, Long.TYPE, String.class, Long.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteEmailAddressParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchEmailAddressParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEmailAddressParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEmailAddressesParameterTypes4 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _updateEmailAddressParameterTypes5 = new Class[]{Long.TYPE, String.class, Long.TYPE, Boolean.TYPE};

    public static EmailAddress addEmailAddress(HttpPrincipal httpPrincipal, String className, long classPK, String address, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "addEmailAddress", _addEmailAddressParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK, address, typeId, primary, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "deleteEmailAddress", _deleteEmailAddressParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, emailAddressId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static EmailAddress fetchEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "fetchEmailAddress", _fetchEmailAddressParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, emailAddressId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static EmailAddress getEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "getEmailAddress", _getEmailAddressParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, emailAddressId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<EmailAddress> getEmailAddresses(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "getEmailAddresses", _getEmailAddressesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static EmailAddress updateEmailAddress(HttpPrincipal httpPrincipal, long emailAddressId, String address, long typeId, boolean primary) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EmailAddressServiceUtil.class, "updateEmailAddress", _updateEmailAddressParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, emailAddressId, address, typeId, primary);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (EmailAddress)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

