/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountrySoap;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CountryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(CountryServiceSoap.class);

    public static CountrySoap addCountry(String name, String a2, String a3, String number, String idd, boolean active) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.addCountry(name, a2, a3, number, idd, active);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap fetchCountry(long countryId) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.fetchCountry(countryId);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap fetchCountryByA2(String a2) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.fetchCountryByA2(a2);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap fetchCountryByA3(String a3) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.fetchCountryByA3(a3);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap[] getCountries() throws RemoteException {
        try {
            List<Country> returnValue = CountryServiceUtil.getCountries();
            return CountrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap[] getCountries(boolean active) throws RemoteException {
        try {
            List<Country> returnValue = CountryServiceUtil.getCountries(active);
            return CountrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap getCountry(long countryId) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.getCountry(countryId);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap getCountryByA2(String a2) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.getCountryByA2(a2);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap getCountryByA3(String a3) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.getCountryByA3(a3);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CountrySoap getCountryByName(String name) throws RemoteException {
        try {
            Country returnValue = CountryServiceUtil.getCountryByName(name);
            return CountrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

