/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ContactSoap;
import com.liferay.portal.kernel.service.ContactServiceUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ContactServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(ContactServiceSoap.class);

    public static ContactSoap[] getCompanyContacts(long companyId, int start, int end) throws RemoteException {
        try {
            List<Contact> returnValue = ContactServiceUtil.getCompanyContacts(companyId, start, end);
            return ContactSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCompanyContactsCount(long companyId) throws RemoteException {
        try {
            int returnValue = ContactServiceUtil.getCompanyContactsCount(companyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ContactSoap getContact(long contactId) throws RemoteException {
        try {
            Contact returnValue = ContactServiceUtil.getContact(contactId);
            return ContactSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ContactSoap[] getContacts(long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws RemoteException {
        try {
            List<Contact> returnValue = ContactServiceUtil.getContacts(classNameId, classPK, start, end, orderByComparator);
            return ContactSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getContactsCount(long classNameId, long classPK) throws RemoteException {
        try {
            int returnValue = ContactServiceUtil.getContactsCount(classNameId, classPK);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

