/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ContactServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ContactServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ContactServiceHttp.class);
    private static final Class<?>[] _getCompanyContactsParameterTypes0 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCompanyContactsCountParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getContactParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getContactsParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getContactsCountParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE};

    public static List<Contact> getCompanyContacts(HttpPrincipal httpPrincipal, long companyId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getCompanyContacts", _getCompanyContactsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId, start, end);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getCompanyContactsCount(HttpPrincipal httpPrincipal, long companyId) {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getCompanyContactsCount", _getCompanyContactsCountParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, companyId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Contact getContact(HttpPrincipal httpPrincipal, long contactId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContact", _getContactParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, contactId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Contact)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Contact> getContacts(HttpPrincipal httpPrincipal, long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContacts", _getContactsParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, classNameId, classPK, start, end, orderByComparator);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getContactsCount(HttpPrincipal httpPrincipal, long classNameId, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContactsCount", _getContactsCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, classNameId, classPK);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

