/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.CompanySoap;
import com.liferay.portal.kernel.service.CompanyServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CompanyServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(CompanyServiceSoap.class);

    public static CompanySoap addCompany(String webId, String virtualHost, String mx, boolean system, int maxUsers, boolean active) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.addCompany(webId, virtualHost, mx, system, maxUsers, active);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap deleteCompany(long companyId) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.deleteCompany(companyId);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteLogo(long companyId) throws RemoteException {
        try {
            CompanyServiceUtil.deleteLogo(companyId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap[] getCompanies() throws RemoteException {
        try {
            List<Company> returnValue = CompanyServiceUtil.getCompanies();
            return CompanySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap getCompanyById(long companyId) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.getCompanyById(companyId);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap getCompanyByLogoId(long logoId) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.getCompanyByLogoId(logoId);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap getCompanyByMx(String mx) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.getCompanyByMx(mx);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap getCompanyByVirtualHost(String virtualHost) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.getCompanyByVirtualHost(virtualHost);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap getCompanyByWebId(String webId) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.getCompanyByWebId(webId);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void removePreferences(long companyId, String[] keys) throws RemoteException {
        try {
            CompanyServiceUtil.removePreferences(companyId, keys);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap updateCompany(long companyId, String virtualHost, String mx, int maxUsers, boolean active) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.updateCompany(companyId, virtualHost, mx, maxUsers, active);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap updateCompany(long companyId, String virtualHost, String mx, String homeURL, boolean logo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.updateCompany(companyId, virtualHost, mx, homeURL, logo, logoBytes, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateDisplay(long companyId, String languageId, String timeZoneId) throws RemoteException {
        try {
            CompanyServiceUtil.updateDisplay(companyId, languageId, timeZoneId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static CompanySoap updateLogo(long companyId, byte[] bytes) throws RemoteException {
        try {
            Company returnValue = CompanyServiceUtil.updateLogo(companyId, bytes);
            return CompanySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws RemoteException {
        try {
            CompanyServiceUtil.updateSecurity(companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, siteLogo);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

