/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ClassNameServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ClassNameServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ClassNameServiceHttp.class);
    private static final Class<?>[] _fetchByClassNameIdParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchClassNameParameterTypes1 = new Class[]{String.class};

    public static ClassName fetchByClassNameId(HttpPrincipal httpPrincipal, long classNameId) {
        try {
            MethodKey methodKey = new MethodKey(ClassNameServiceUtil.class, "fetchByClassNameId", _fetchByClassNameIdParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, classNameId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (ClassName)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static ClassName fetchClassName(HttpPrincipal httpPrincipal, String value) {
        try {
            MethodKey methodKey = new MethodKey(ClassNameServiceUtil.class, "fetchClassName", _fetchClassNameParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, value);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
            return (ClassName)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

