/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AddressSoap;
import com.liferay.portal.kernel.service.AddressServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AddressServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AddressServiceSoap.class);

    public static AddressSoap addAddress(String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws RemoteException {
        try {
            Address returnValue = AddressServiceUtil.addAddress(className, classPK, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary, serviceContext);
            return AddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteAddress(long addressId) throws RemoteException {
        try {
            AddressServiceUtil.deleteAddress(addressId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AddressSoap getAddress(long addressId) throws RemoteException {
        try {
            Address returnValue = AddressServiceUtil.getAddress(addressId);
            return AddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AddressSoap[] getAddresses(String className, long classPK) throws RemoteException {
        try {
            List<Address> returnValue = AddressServiceUtil.getAddresses(className, classPK);
            return AddressSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AddressSoap updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws RemoteException {
        try {
            Address returnValue = AddressServiceUtil.updateAddress(addressId, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary);
            return AddressSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

