/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.AddressServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AddressServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AddressServiceHttp.class);
    private static final Class<?>[] _addAddressParameterTypes0 = new Class[]{String.class, Long.TYPE, String.class, String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteAddressParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getAddressParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getAddressesParameterTypes3 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _updateAddressParameterTypes4 = new Class[]{Long.TYPE, String.class, String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE};

    public static Address addAddress(HttpPrincipal httpPrincipal, String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "addAddress", _addAddressParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Address)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void deleteAddress(HttpPrincipal httpPrincipal, long addressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "deleteAddress", _deleteAddressParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, addressId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Address getAddress(HttpPrincipal httpPrincipal, long addressId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "getAddress", _getAddressParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, addressId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Address)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<Address> getAddresses(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "getAddresses", _getAddressesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, className, classPK);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Address updateAddress(HttpPrincipal httpPrincipal, long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AddressServiceUtil.class, "updateAddress", _updateAddressParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, addressId, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Address)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

