/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.service.persistence.ClassNamePersistence;
import com.liferay.portal.kernel.service.persistence.ListTypePersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.WebsitePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class WebsiteLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements WebsiteLocalService,
IdentifiableOSGiService {
    @BeanReference(type=WebsiteLocalService.class)
    protected WebsiteLocalService websiteLocalService;
    @BeanReference(type=WebsitePersistence.class)
    protected WebsitePersistence websitePersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    protected ClassNameLocalService classNameLocalService;
    @BeanReference(type=ClassNamePersistence.class)
    protected ClassNamePersistence classNamePersistence;
    @BeanReference(type=ListTypeLocalService.class)
    protected ListTypeLocalService listTypeLocalService;
    @BeanReference(type=ListTypePersistence.class)
    protected ListTypePersistence listTypePersistence;
    @BeanReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserFinder.class)
    protected UserFinder userFinder;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Website addWebsite(Website website) {
        website.setNew(true);
        return this.websitePersistence.update(website);
    }

    @Override
    @Transactional(enabled=false)
    public Website createWebsite(long websiteId) {
        return this.websitePersistence.create(websiteId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Website deleteWebsite(long websiteId) throws PortalException {
        return this.websitePersistence.remove(websiteId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Website deleteWebsite(Website website) {
        return this.websitePersistence.remove(website);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = this.getClass();
        return DynamicQueryFactoryUtil.forClass(Website.class, clazz.getClassLoader());
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.websitePersistence.findWithDynamicQuery(dynamicQuery);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.websitePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.websitePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.websitePersistence.countWithDynamicQuery(dynamicQuery);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.websitePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public Website fetchWebsite(long websiteId) {
        return this.websitePersistence.fetchByPrimaryKey(websiteId);
    }

    @Override
    public Website fetchWebsiteByUuidAndCompanyId(String uuid, long companyId) {
        return this.websitePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    @Override
    public Website getWebsite(long websiteId) throws PortalException {
        return this.websitePersistence.findByPrimaryKey(websiteId);
    }

    @Override
    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService(this.websiteLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Website.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("websiteId");
        return actionableDynamicQuery;
    }

    @Override
    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService(this.websiteLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Website.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("websiteId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService(this.websiteLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Website.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("websiteId");
    }

    @Override
    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            @Override
            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery(exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            @Override
            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName("classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq(stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod<Website>(){

            @Override
            public void performAction(Website website) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, website);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId(Website.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    @Override
    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.websiteLocalService.deleteWebsite((Website)persistedModel);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.websitePersistence.findByPrimaryKey(primaryKeyObj);
    }

    @Override
    public Website getWebsiteByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.websitePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    @Override
    public List<Website> getWebsites(int start, int end) {
        return this.websitePersistence.findAll(start, end);
    }

    @Override
    public int getWebsitesCount() {
        return this.websitePersistence.countAll();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Website updateWebsite(Website website) {
        return this.websitePersistence.update(website);
    }

    public WebsiteLocalService getWebsiteLocalService() {
        return this.websiteLocalService;
    }

    public void setWebsiteLocalService(WebsiteLocalService websiteLocalService) {
        this.websiteLocalService = websiteLocalService;
    }

    public WebsitePersistence getWebsitePersistence() {
        return this.websitePersistence;
    }

    public void setWebsitePersistence(WebsitePersistence websitePersistence) {
        this.websitePersistence = websitePersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public ClassNameLocalService getClassNameLocalService() {
        return this.classNameLocalService;
    }

    public void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this.classNameLocalService = classNameLocalService;
    }

    public ClassNamePersistence getClassNamePersistence() {
        return this.classNamePersistence;
    }

    public void setClassNamePersistence(ClassNamePersistence classNamePersistence) {
        this.classNamePersistence = classNamePersistence;
    }

    public ListTypeLocalService getListTypeLocalService() {
        return this.listTypeLocalService;
    }

    public void setListTypeLocalService(ListTypeLocalService listTypeLocalService) {
        this.listTypeLocalService = listTypeLocalService;
    }

    public ListTypePersistence getListTypePersistence() {
        return this.listTypePersistence;
    }

    public void setListTypePersistence(ListTypePersistence listTypePersistence) {
        this.listTypePersistence = listTypePersistence;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public UserFinder getUserFinder() {
        return this.userFinder;
    }

    public void setUserFinder(UserFinder userFinder) {
        this.userFinder = userFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.Website", this.websiteLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.Website");
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return WebsiteLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Website.class;
    }

    protected String getModelClassName() {
        return Website.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.websitePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL(sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

