/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.RoleFinder;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.TeamFinder;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class TeamLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements TeamLocalService,
IdentifiableOSGiService {
    @BeanReference(type=TeamLocalService.class)
    protected TeamLocalService teamLocalService;
    @BeanReference(type=TeamPersistence.class)
    protected TeamPersistence teamPersistence;
    @BeanReference(type=TeamFinder.class)
    protected TeamFinder teamFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=GroupFinder.class)
    protected GroupFinder groupFinder;
    @BeanReference(type=ResourceLocalService.class)
    protected ResourceLocalService resourceLocalService;
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    @BeanReference(type=RolePersistence.class)
    protected RolePersistence rolePersistence;
    @BeanReference(type=RoleFinder.class)
    protected RoleFinder roleFinder;
    @BeanReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserFinder.class)
    protected UserFinder userFinder;
    @BeanReference(type=UserGroupLocalService.class)
    protected UserGroupLocalService userGroupLocalService;
    @BeanReference(type=UserGroupPersistence.class)
    protected UserGroupPersistence userGroupPersistence;
    @BeanReference(type=UserGroupFinder.class)
    protected UserGroupFinder userGroupFinder;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Team addTeam(Team team) {
        team.setNew(true);
        return this.teamPersistence.update(team);
    }

    @Override
    @Transactional(enabled=false)
    public Team createTeam(long teamId) {
        return this.teamPersistence.create(teamId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Team deleteTeam(long teamId) throws PortalException {
        return this.teamPersistence.remove(teamId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Team deleteTeam(Team team) throws PortalException {
        return this.teamPersistence.remove(team);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = this.getClass();
        return DynamicQueryFactoryUtil.forClass(Team.class, clazz.getClassLoader());
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.teamPersistence.findWithDynamicQuery(dynamicQuery);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.teamPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.teamPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.teamPersistence.countWithDynamicQuery(dynamicQuery);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.teamPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public Team fetchTeam(long teamId) {
        return this.teamPersistence.fetchByPrimaryKey(teamId);
    }

    @Override
    public Team fetchTeamByUuidAndGroupId(String uuid, long groupId) {
        return this.teamPersistence.fetchByUUID_G(uuid, groupId);
    }

    @Override
    public Team getTeam(long teamId) throws PortalException {
        return this.teamPersistence.findByPrimaryKey(teamId);
    }

    @Override
    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService(this.teamLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Team.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("teamId");
        return actionableDynamicQuery;
    }

    @Override
    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService(this.teamLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Team.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("teamId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService(this.teamLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Team.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("teamId");
    }

    @Override
    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            @Override
            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery(exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            @Override
            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod<Team>(){

            @Override
            public void performAction(Team team) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, team);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId(Team.class.getName())));
        return exportActionableDynamicQuery;
    }

    @Override
    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.teamLocalService.deleteTeam((Team)persistedModel);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.teamPersistence.findByPrimaryKey(primaryKeyObj);
    }

    @Override
    public List<Team> getTeamsByUuidAndCompanyId(String uuid, long companyId) {
        return this.teamPersistence.findByUuid_C(uuid, companyId);
    }

    @Override
    public List<Team> getTeamsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.teamPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    @Override
    public Team getTeamByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.teamPersistence.findByUUID_G(uuid, groupId);
    }

    @Override
    public List<Team> getTeams(int start, int end) {
        return this.teamPersistence.findAll(start, end);
    }

    @Override
    public int getTeamsCount() {
        return this.teamPersistence.countAll();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Team updateTeam(Team team) {
        return this.teamPersistence.update(team);
    }

    @Override
    public void addUserTeam(long userId, long teamId) {
        this.userPersistence.addTeam(userId, teamId);
    }

    @Override
    public void addUserTeam(long userId, Team team) {
        this.userPersistence.addTeam(userId, team);
    }

    @Override
    public void addUserTeams(long userId, long[] teamIds) {
        this.userPersistence.addTeams(userId, teamIds);
    }

    @Override
    public void addUserTeams(long userId, List<Team> teams) {
        this.userPersistence.addTeams(userId, teams);
    }

    @Override
    public void clearUserTeams(long userId) {
        this.userPersistence.clearTeams(userId);
    }

    @Override
    public void deleteUserTeam(long userId, long teamId) {
        this.userPersistence.removeTeam(userId, teamId);
    }

    @Override
    public void deleteUserTeam(long userId, Team team) {
        this.userPersistence.removeTeam(userId, team);
    }

    @Override
    public void deleteUserTeams(long userId, long[] teamIds) {
        this.userPersistence.removeTeams(userId, teamIds);
    }

    @Override
    public void deleteUserTeams(long userId, List<Team> teams) {
        this.userPersistence.removeTeams(userId, teams);
    }

    @Override
    public long[] getUserPrimaryKeys(long teamId) {
        return this.teamPersistence.getUserPrimaryKeys(teamId);
    }

    @Override
    public List<Team> getUserTeams(long userId) {
        return this.userPersistence.getTeams(userId);
    }

    @Override
    public List<Team> getUserTeams(long userId, int start, int end) {
        return this.userPersistence.getTeams(userId, start, end);
    }

    @Override
    public List<Team> getUserTeams(long userId, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.userPersistence.getTeams(userId, start, end, orderByComparator);
    }

    @Override
    public int getUserTeamsCount(long userId) {
        return this.userPersistence.getTeamsSize(userId);
    }

    @Override
    public boolean hasUserTeam(long userId, long teamId) {
        return this.userPersistence.containsTeam(userId, teamId);
    }

    @Override
    public boolean hasUserTeams(long userId) {
        return this.userPersistence.containsTeams(userId);
    }

    @Override
    public void setUserTeams(long userId, long[] teamIds) {
        this.userPersistence.setTeams(userId, teamIds);
    }

    @Override
    public void addUserGroupTeam(long userGroupId, long teamId) {
        this.userGroupPersistence.addTeam(userGroupId, teamId);
    }

    @Override
    public void addUserGroupTeam(long userGroupId, Team team) {
        this.userGroupPersistence.addTeam(userGroupId, team);
    }

    @Override
    public void addUserGroupTeams(long userGroupId, long[] teamIds) {
        this.userGroupPersistence.addTeams(userGroupId, teamIds);
    }

    @Override
    public void addUserGroupTeams(long userGroupId, List<Team> teams) {
        this.userGroupPersistence.addTeams(userGroupId, teams);
    }

    @Override
    public void clearUserGroupTeams(long userGroupId) {
        this.userGroupPersistence.clearTeams(userGroupId);
    }

    @Override
    public void deleteUserGroupTeam(long userGroupId, long teamId) {
        this.userGroupPersistence.removeTeam(userGroupId, teamId);
    }

    @Override
    public void deleteUserGroupTeam(long userGroupId, Team team) {
        this.userGroupPersistence.removeTeam(userGroupId, team);
    }

    @Override
    public void deleteUserGroupTeams(long userGroupId, long[] teamIds) {
        this.userGroupPersistence.removeTeams(userGroupId, teamIds);
    }

    @Override
    public void deleteUserGroupTeams(long userGroupId, List<Team> teams) {
        this.userGroupPersistence.removeTeams(userGroupId, teams);
    }

    @Override
    public long[] getUserGroupPrimaryKeys(long teamId) {
        return this.teamPersistence.getUserGroupPrimaryKeys(teamId);
    }

    @Override
    public List<Team> getUserGroupTeams(long userGroupId) {
        return this.userGroupPersistence.getTeams(userGroupId);
    }

    @Override
    public List<Team> getUserGroupTeams(long userGroupId, int start, int end) {
        return this.userGroupPersistence.getTeams(userGroupId, start, end);
    }

    @Override
    public List<Team> getUserGroupTeams(long userGroupId, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.userGroupPersistence.getTeams(userGroupId, start, end, orderByComparator);
    }

    @Override
    public int getUserGroupTeamsCount(long userGroupId) {
        return this.userGroupPersistence.getTeamsSize(userGroupId);
    }

    @Override
    public boolean hasUserGroupTeam(long userGroupId, long teamId) {
        return this.userGroupPersistence.containsTeam(userGroupId, teamId);
    }

    @Override
    public boolean hasUserGroupTeams(long userGroupId) {
        return this.userGroupPersistence.containsTeams(userGroupId);
    }

    @Override
    public void setUserGroupTeams(long userGroupId, long[] teamIds) {
        this.userGroupPersistence.setTeams(userGroupId, teamIds);
    }

    public TeamLocalService getTeamLocalService() {
        return this.teamLocalService;
    }

    public void setTeamLocalService(TeamLocalService teamLocalService) {
        this.teamLocalService = teamLocalService;
    }

    public TeamPersistence getTeamPersistence() {
        return this.teamPersistence;
    }

    public void setTeamPersistence(TeamPersistence teamPersistence) {
        this.teamPersistence = teamPersistence;
    }

    public TeamFinder getTeamFinder() {
        return this.teamFinder;
    }

    public void setTeamFinder(TeamFinder teamFinder) {
        this.teamFinder = teamFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public GroupLocalService getGroupLocalService() {
        return this.groupLocalService;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public GroupPersistence getGroupPersistence() {
        return this.groupPersistence;
    }

    public void setGroupPersistence(GroupPersistence groupPersistence) {
        this.groupPersistence = groupPersistence;
    }

    public GroupFinder getGroupFinder() {
        return this.groupFinder;
    }

    public void setGroupFinder(GroupFinder groupFinder) {
        this.groupFinder = groupFinder;
    }

    public ResourceLocalService getResourceLocalService() {
        return this.resourceLocalService;
    }

    public void setResourceLocalService(ResourceLocalService resourceLocalService) {
        this.resourceLocalService = resourceLocalService;
    }

    public RoleLocalService getRoleLocalService() {
        return this.roleLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public RolePersistence getRolePersistence() {
        return this.rolePersistence;
    }

    public void setRolePersistence(RolePersistence rolePersistence) {
        this.rolePersistence = rolePersistence;
    }

    public RoleFinder getRoleFinder() {
        return this.roleFinder;
    }

    public void setRoleFinder(RoleFinder roleFinder) {
        this.roleFinder = roleFinder;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public UserFinder getUserFinder() {
        return this.userFinder;
    }

    public void setUserFinder(UserFinder userFinder) {
        this.userFinder = userFinder;
    }

    public UserGroupLocalService getUserGroupLocalService() {
        return this.userGroupLocalService;
    }

    public void setUserGroupLocalService(UserGroupLocalService userGroupLocalService) {
        this.userGroupLocalService = userGroupLocalService;
    }

    public UserGroupPersistence getUserGroupPersistence() {
        return this.userGroupPersistence;
    }

    public void setUserGroupPersistence(UserGroupPersistence userGroupPersistence) {
        this.userGroupPersistence = userGroupPersistence;
    }

    public UserGroupFinder getUserGroupFinder() {
        return this.userGroupFinder;
    }

    public void setUserGroupFinder(UserGroupFinder userGroupFinder) {
        this.userGroupFinder = userGroupFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.Team", this.teamLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.Team");
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return TeamLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Team.class;
    }

    protected String getModelClassName() {
        return Team.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.teamPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL(sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

