/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetVersion;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.PluginSettingLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.ImagePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutFinder;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetBranchPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetVersionPersistence;
import com.liferay.portal.kernel.service.persistence.PluginSettingPersistence;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.service.version.VersionService;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class LayoutSetLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements LayoutSetLocalService,
IdentifiableOSGiService,
VersionService<LayoutSet, LayoutSetVersion> {
    private final Set<VersionServiceListener<LayoutSet, LayoutSetVersion>> _versionServiceListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    @BeanReference(type=LayoutSetLocalService.class)
    protected LayoutSetLocalService layoutSetLocalService;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=GroupFinder.class)
    protected GroupFinder groupFinder;
    @BeanReference(type=ImageLocalService.class)
    protected ImageLocalService imageLocalService;
    @BeanReference(type=ImagePersistence.class)
    protected ImagePersistence imagePersistence;
    @BeanReference(type=LayoutLocalService.class)
    protected LayoutLocalService layoutLocalService;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutFinder.class)
    protected LayoutFinder layoutFinder;
    @BeanReference(type=LayoutSetVersionPersistence.class)
    protected LayoutSetVersionPersistence layoutSetVersionPersistence;
    @BeanReference(type=LayoutSetBranchLocalService.class)
    protected LayoutSetBranchLocalService layoutSetBranchLocalService;
    @BeanReference(type=LayoutSetBranchPersistence.class)
    protected LayoutSetBranchPersistence layoutSetBranchPersistence;
    @BeanReference(type=PluginSettingLocalService.class)
    protected PluginSettingLocalService pluginSettingLocalService;
    @BeanReference(type=PluginSettingPersistence.class)
    protected PluginSettingPersistence pluginSettingPersistence;
    @BeanReference(type=VirtualHostLocalService.class)
    protected VirtualHostLocalService virtualHostLocalService;
    @BeanReference(type=VirtualHostPersistence.class)
    protected VirtualHostPersistence virtualHostPersistence;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet addLayoutSet(LayoutSet layoutSet) {
        layoutSet.setNew(true);
        return this.layoutSetPersistence.update(layoutSet);
    }

    @Override
    @Transactional(enabled=false)
    public LayoutSet create() {
        long primaryKey = this.counterLocalService.increment(LayoutSet.class.getName());
        LayoutSet draftLayoutSet = this.layoutSetPersistence.create(primaryKey);
        draftLayoutSet.setHeadId(primaryKey);
        return draftLayoutSet;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteLayoutSet(long layoutSetId) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.fetchByPrimaryKey(layoutSetId);
        if (layoutSet != null) {
            this.delete(layoutSet);
        }
        return layoutSet;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteLayoutSet(LayoutSet layoutSet) {
        try {
            this.delete(layoutSet);
            return layoutSet;
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = this.getClass();
        return DynamicQueryFactoryUtil.forClass(LayoutSet.class, clazz.getClassLoader());
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.layoutSetPersistence.countWithDynamicQuery(dynamicQuery);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.layoutSetPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public LayoutSet fetchLayoutSet(long layoutSetId) {
        return this.layoutSetPersistence.fetchByPrimaryKey(layoutSetId);
    }

    @Override
    public LayoutSet getLayoutSet(long layoutSetId) throws PortalException {
        return this.layoutSetPersistence.findByPrimaryKey(layoutSetId);
    }

    @Override
    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService(this.layoutSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
        return actionableDynamicQuery;
    }

    @Override
    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService(this.layoutSetLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(LayoutSet.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService(this.layoutSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
    }

    @Override
    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.layoutSetLocalService.deleteLayoutSet((LayoutSet)persistedModel);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.layoutSetPersistence.findByPrimaryKey(primaryKeyObj);
    }

    @Override
    public List<LayoutSet> getLayoutSets(int start, int end) {
        return this.layoutSetPersistence.findAll(start, end);
    }

    @Override
    public int getLayoutSetsCount() {
        return this.layoutSetPersistence.countAll();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet updateLayoutSet(LayoutSet draftLayoutSet) throws PortalException {
        return this.updateDraft(draftLayoutSet);
    }

    public LayoutSetLocalService getLayoutSetLocalService() {
        return this.layoutSetLocalService;
    }

    public void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this.layoutSetLocalService = layoutSetLocalService;
    }

    public LayoutSetPersistence getLayoutSetPersistence() {
        return this.layoutSetPersistence;
    }

    public void setLayoutSetPersistence(LayoutSetPersistence layoutSetPersistence) {
        this.layoutSetPersistence = layoutSetPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public GroupLocalService getGroupLocalService() {
        return this.groupLocalService;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public GroupPersistence getGroupPersistence() {
        return this.groupPersistence;
    }

    public void setGroupPersistence(GroupPersistence groupPersistence) {
        this.groupPersistence = groupPersistence;
    }

    public GroupFinder getGroupFinder() {
        return this.groupFinder;
    }

    public void setGroupFinder(GroupFinder groupFinder) {
        this.groupFinder = groupFinder;
    }

    public ImageLocalService getImageLocalService() {
        return this.imageLocalService;
    }

    public void setImageLocalService(ImageLocalService imageLocalService) {
        this.imageLocalService = imageLocalService;
    }

    public ImagePersistence getImagePersistence() {
        return this.imagePersistence;
    }

    public void setImagePersistence(ImagePersistence imagePersistence) {
        this.imagePersistence = imagePersistence;
    }

    public LayoutLocalService getLayoutLocalService() {
        return this.layoutLocalService;
    }

    public void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this.layoutLocalService = layoutLocalService;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this.layoutPersistence;
    }

    public void setLayoutPersistence(LayoutPersistence layoutPersistence) {
        this.layoutPersistence = layoutPersistence;
    }

    public LayoutFinder getLayoutFinder() {
        return this.layoutFinder;
    }

    public void setLayoutFinder(LayoutFinder layoutFinder) {
        this.layoutFinder = layoutFinder;
    }

    public LayoutSetVersionPersistence getLayoutSetVersionPersistence() {
        return this.layoutSetVersionPersistence;
    }

    public void setLayoutSetVersionPersistence(LayoutSetVersionPersistence layoutSetVersionPersistence) {
        this.layoutSetVersionPersistence = layoutSetVersionPersistence;
    }

    public LayoutSetBranchLocalService getLayoutSetBranchLocalService() {
        return this.layoutSetBranchLocalService;
    }

    public void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this.layoutSetBranchLocalService = layoutSetBranchLocalService;
    }

    public LayoutSetBranchPersistence getLayoutSetBranchPersistence() {
        return this.layoutSetBranchPersistence;
    }

    public void setLayoutSetBranchPersistence(LayoutSetBranchPersistence layoutSetBranchPersistence) {
        this.layoutSetBranchPersistence = layoutSetBranchPersistence;
    }

    public PluginSettingLocalService getPluginSettingLocalService() {
        return this.pluginSettingLocalService;
    }

    public void setPluginSettingLocalService(PluginSettingLocalService pluginSettingLocalService) {
        this.pluginSettingLocalService = pluginSettingLocalService;
    }

    public PluginSettingPersistence getPluginSettingPersistence() {
        return this.pluginSettingPersistence;
    }

    public void setPluginSettingPersistence(PluginSettingPersistence pluginSettingPersistence) {
        this.pluginSettingPersistence = pluginSettingPersistence;
    }

    public VirtualHostLocalService getVirtualHostLocalService() {
        return this.virtualHostLocalService;
    }

    public void setVirtualHostLocalService(VirtualHostLocalService virtualHostLocalService) {
        this.virtualHostLocalService = virtualHostLocalService;
    }

    public VirtualHostPersistence getVirtualHostPersistence() {
        return this.virtualHostPersistence;
    }

    public void setVirtualHostPersistence(VirtualHostPersistence virtualHostPersistence) {
        this.virtualHostPersistence = virtualHostPersistence;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.LayoutSet", this.layoutSetLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.LayoutSet");
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet checkout(LayoutSet publishedLayoutSet, int version) throws PortalException {
        if (!publishedLayoutSet.isHead()) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedLayoutSet.getHeadId());
        }
        LayoutSet draftLayoutSet = this.layoutSetPersistence.fetchByHeadId(publishedLayoutSet.getPrimaryKey());
        if (draftLayoutSet != null) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedLayoutSet.getPrimaryKey());
        }
        LayoutSetVersion layoutSetVersion = this.getVersion(publishedLayoutSet, version);
        draftLayoutSet = this._createDraft(publishedLayoutSet);
        layoutSetVersion.populateVersionedModel(draftLayoutSet);
        draftLayoutSet = this.layoutSetPersistence.update(draftLayoutSet);
        for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterCheckout(draftLayoutSet, version);
        }
        return draftLayoutSet;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet delete(LayoutSet publishedLayoutSet) throws PortalException {
        if (!publishedLayoutSet.isHead()) {
            throw new IllegalArgumentException("LayoutSet is a draft " + publishedLayoutSet.getPrimaryKey());
        }
        LayoutSet draftLayoutSet = this.layoutSetPersistence.fetchByHeadId(publishedLayoutSet.getPrimaryKey());
        if (draftLayoutSet != null) {
            this.deleteDraft(draftLayoutSet);
        }
        for (LayoutSetVersion layoutSetVersion : this.getVersions(publishedLayoutSet)) {
            this.layoutSetVersionPersistence.remove(layoutSetVersion);
        }
        this.layoutSetPersistence.remove(publishedLayoutSet);
        for (VersionServiceListener versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDelete(publishedLayoutSet);
        }
        return publishedLayoutSet;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteDraft(LayoutSet draftLayoutSet) throws PortalException {
        if (draftLayoutSet.isHead()) {
            throw new IllegalArgumentException("LayoutSet is not a draft " + draftLayoutSet.getPrimaryKey());
        }
        this.layoutSetPersistence.remove(draftLayoutSet);
        for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteDraft(draftLayoutSet);
        }
        return draftLayoutSet;
    }

    @Override
    public LayoutSetVersion deleteVersion(LayoutSetVersion layoutSetVersion) throws PortalException {
        LayoutSetVersion latestLayoutSetVersion = this.layoutSetVersionPersistence.findByLayoutSetId_First(layoutSetVersion.getVersionedModelId(), null);
        if (latestLayoutSetVersion.getVersion() == layoutSetVersion.getVersion()) {
            throw new IllegalArgumentException("Unable to delete latest version " + layoutSetVersion.getVersion());
        }
        layoutSetVersion = this.layoutSetVersionPersistence.remove(layoutSetVersion);
        for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteVersion(layoutSetVersion);
        }
        return layoutSetVersion;
    }

    @Override
    public LayoutSet fetchDraft(LayoutSet layoutSet) {
        if (layoutSet.isHead()) {
            return this.layoutSetPersistence.fetchByHeadId(layoutSet.getPrimaryKey());
        }
        return layoutSet;
    }

    @Override
    public LayoutSet fetchDraft(long primaryKey) {
        return this.layoutSetPersistence.fetchByHeadId(primaryKey);
    }

    @Override
    public LayoutSetVersion fetchLatestVersion(LayoutSet layoutSet) {
        long primaryKey = layoutSet.getHeadId();
        if (layoutSet.isHead()) {
            primaryKey = layoutSet.getPrimaryKey();
        }
        return this.layoutSetVersionPersistence.fetchByLayoutSetId_First(primaryKey, null);
    }

    @Override
    public LayoutSet fetchPublished(LayoutSet layoutSet) {
        if (layoutSet.isHead()) {
            return layoutSet;
        }
        if (layoutSet.getHeadId() == layoutSet.getPrimaryKey()) {
            return null;
        }
        return this.layoutSetPersistence.fetchByPrimaryKey(layoutSet.getHeadId());
    }

    @Override
    public LayoutSet fetchPublished(long primaryKey) {
        LayoutSet layoutSet = this.layoutSetPersistence.fetchByPrimaryKey(primaryKey);
        if (layoutSet == null || layoutSet.getHeadId() == layoutSet.getPrimaryKey()) {
            return null;
        }
        return layoutSet;
    }

    @Override
    public LayoutSet getDraft(LayoutSet layoutSet) throws PortalException {
        if (!layoutSet.isHead()) {
            return layoutSet;
        }
        LayoutSet draftLayoutSet = this.layoutSetPersistence.fetchByHeadId(layoutSet.getPrimaryKey());
        if (draftLayoutSet == null) {
            draftLayoutSet = this.layoutSetLocalService.updateDraft(this._createDraft(layoutSet));
        }
        return draftLayoutSet;
    }

    @Override
    public LayoutSet getDraft(long primaryKey) throws PortalException {
        LayoutSet draftLayoutSet = this.layoutSetPersistence.fetchByHeadId(primaryKey);
        if (draftLayoutSet == null) {
            LayoutSet layoutSet = this.layoutSetPersistence.findByPrimaryKey(primaryKey);
            draftLayoutSet = this.layoutSetLocalService.updateDraft(this._createDraft(layoutSet));
        }
        return draftLayoutSet;
    }

    @Override
    public LayoutSetVersion getVersion(LayoutSet layoutSet, int version) throws PortalException {
        long primaryKey = layoutSet.getHeadId();
        if (layoutSet.isHead()) {
            primaryKey = layoutSet.getPrimaryKey();
        }
        return this.layoutSetVersionPersistence.findByLayoutSetId_Version(primaryKey, version);
    }

    @Override
    public List<LayoutSetVersion> getVersions(LayoutSet layoutSet) {
        long primaryKey = layoutSet.getPrimaryKey();
        if (!layoutSet.isHead()) {
            if (layoutSet.getHeadId() == layoutSet.getPrimaryKey()) {
                return Collections.emptyList();
            }
            primaryKey = layoutSet.getHeadId();
        }
        return this.layoutSetVersionPersistence.findByLayoutSetId(primaryKey);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet publishDraft(LayoutSet draftLayoutSet) throws PortalException {
        if (draftLayoutSet.isHead()) {
            throw new IllegalArgumentException("Can only publish drafts " + draftLayoutSet.getPrimaryKey());
        }
        LayoutSet headLayoutSet = null;
        int version = 1;
        if (draftLayoutSet.getHeadId() == draftLayoutSet.getPrimaryKey()) {
            headLayoutSet = this.create();
            draftLayoutSet.setHeadId(headLayoutSet.getPrimaryKey());
        } else {
            headLayoutSet = this.layoutSetPersistence.findByPrimaryKey(draftLayoutSet.getHeadId());
            LayoutSetVersion latestLayoutSetVersion = this.layoutSetVersionPersistence.findByLayoutSetId_First(draftLayoutSet.getHeadId(), null);
            version = latestLayoutSetVersion.getVersion() + 1;
        }
        LayoutSetVersion layoutSetVersion = this.layoutSetVersionPersistence.create(this.counterLocalService.increment(LayoutSetVersion.class.getName()));
        layoutSetVersion.setVersion(version);
        layoutSetVersion.setVersionedModelId(headLayoutSet.getPrimaryKey());
        draftLayoutSet.populateVersionModel(layoutSetVersion);
        this.layoutSetVersionPersistence.update(layoutSetVersion);
        layoutSetVersion.populateVersionedModel(headLayoutSet);
        headLayoutSet.setHeadId(-headLayoutSet.getPrimaryKey());
        headLayoutSet = this.layoutSetPersistence.update(headLayoutSet);
        for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterPublishDraft(draftLayoutSet, version);
        }
        this.deleteDraft(draftLayoutSet);
        return headLayoutSet;
    }

    @Override
    public void registerListener(VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener) {
        this._versionServiceListeners.add(versionServiceListener);
    }

    @Override
    public void unregisterListener(VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener) {
        this._versionServiceListeners.remove(versionServiceListener);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet updateDraft(LayoutSet draftLayoutSet) throws PortalException {
        if (draftLayoutSet.isHead()) {
            throw new IllegalArgumentException("Can only update draft entries " + draftLayoutSet.getPrimaryKey());
        }
        LayoutSet previousLayoutSet = this.layoutSetPersistence.fetchByPrimaryKey(draftLayoutSet.getPrimaryKey());
        draftLayoutSet = this.layoutSetPersistence.update(draftLayoutSet);
        if (previousLayoutSet == null) {
            for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterCreateDraft(draftLayoutSet);
            }
        } else {
            for (VersionServiceListener<LayoutSet, LayoutSetVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterUpdateDraft(draftLayoutSet);
            }
        }
        return draftLayoutSet;
    }

    private LayoutSet _createDraft(LayoutSet publishedLayoutSet) throws PortalException {
        LayoutSet draftLayoutSet = this.create();
        draftLayoutSet.setHeadId(publishedLayoutSet.getPrimaryKey());
        draftLayoutSet.setGroupId(publishedLayoutSet.getGroupId());
        draftLayoutSet.setCompanyId(publishedLayoutSet.getCompanyId());
        draftLayoutSet.setCreateDate(publishedLayoutSet.getCreateDate());
        draftLayoutSet.setModifiedDate(publishedLayoutSet.getModifiedDate());
        draftLayoutSet.setPrivateLayout(publishedLayoutSet.getPrivateLayout());
        draftLayoutSet.setLogoId(publishedLayoutSet.getLogoId());
        draftLayoutSet.setThemeId(publishedLayoutSet.getThemeId());
        draftLayoutSet.setColorSchemeId(publishedLayoutSet.getColorSchemeId());
        draftLayoutSet.setCss(publishedLayoutSet.getCss());
        draftLayoutSet.setPageCount(publishedLayoutSet.getPageCount());
        draftLayoutSet.setSettings(publishedLayoutSet.getSettings());
        draftLayoutSet.setLayoutSetPrototypeUuid(publishedLayoutSet.getLayoutSetPrototypeUuid());
        draftLayoutSet.setLayoutSetPrototypeLinkEnabled(publishedLayoutSet.getLayoutSetPrototypeLinkEnabled());
        draftLayoutSet.resetOriginalValues();
        return draftLayoutSet;
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return LayoutSetLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return LayoutSet.class;
    }

    protected String getModelClassName() {
        return LayoutSet.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.layoutSetPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL(sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

