/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.AccountLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.persistence.AccountPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class AccountLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AccountLocalService,
IdentifiableOSGiService {
    @BeanReference(type=AccountLocalService.class)
    protected AccountLocalService accountLocalService;
    @BeanReference(type=AccountPersistence.class)
    protected AccountPersistence accountPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Account addAccount(Account account) {
        account.setNew(true);
        return this.accountPersistence.update(account);
    }

    @Override
    @Transactional(enabled=false)
    public Account createAccount(long accountId) {
        return this.accountPersistence.create(accountId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Account deleteAccount(long accountId) throws PortalException {
        return this.accountPersistence.remove(accountId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public Account deleteAccount(Account account) {
        return this.accountPersistence.remove(account);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = this.getClass();
        return DynamicQueryFactoryUtil.forClass(Account.class, clazz.getClassLoader());
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.accountPersistence.countWithDynamicQuery(dynamicQuery);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.accountPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public Account fetchAccount(long accountId) {
        return this.accountPersistence.fetchByPrimaryKey(accountId);
    }

    @Override
    public Account getAccount(long accountId) throws PortalException {
        return this.accountPersistence.findByPrimaryKey(accountId);
    }

    @Override
    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService(this.accountLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Account.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
        return actionableDynamicQuery;
    }

    @Override
    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService(this.accountLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Account.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService(this.accountLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Account.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
    }

    @Override
    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.accountLocalService.deleteAccount((Account)persistedModel);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.accountPersistence.findByPrimaryKey(primaryKeyObj);
    }

    @Override
    public List<Account> getAccounts(int start, int end) {
        return this.accountPersistence.findAll(start, end);
    }

    @Override
    public int getAccountsCount() {
        return this.accountPersistence.countAll();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public Account updateAccount(Account account) {
        return this.accountPersistence.update(account);
    }

    public AccountLocalService getAccountLocalService() {
        return this.accountLocalService;
    }

    public void setAccountLocalService(AccountLocalService accountLocalService) {
        this.accountLocalService = accountLocalService;
    }

    public AccountPersistence getAccountPersistence() {
        return this.accountPersistence;
    }

    public void setAccountPersistence(AccountPersistence accountPersistence) {
        this.accountPersistence = accountPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.kernel.model.Account", this.accountLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.kernel.model.Account");
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return AccountLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Account.class;
    }

    protected String getModelClassName() {
        return Account.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.accountPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL(sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

