/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class ServiceContextAdvice
extends ChainableMethodAdvice {
    @Override
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        int index = this._getServiceContextParameterIndex(method);
        if (index == -1) {
            return null;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        int index = (Integer)aopMethodInvocation.getAdviceMethodContext();
        ServiceContext serviceContext = (ServiceContext)arguments[index];
        if (serviceContext != null) {
            ServiceContextThreadLocal.pushServiceContext(serviceContext);
        }
        try {
            Object object = aopMethodInvocation.proceed(arguments);
            return object;
        }
        finally {
            if (serviceContext != null) {
                ServiceContextThreadLocal.popServiceContext();
            }
        }
    }

    private int _getServiceContextParameterIndex(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = parameterTypes.length - 1; i >= 0; --i) {
            if (!ServiceContext.class.isAssignableFrom(parameterTypes[i])) continue;
            return i;
        }
        return -1;
    }
}

