/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.PermissionedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class PersistedModelLocalServiceRegistryImpl
implements PersistedModelLocalServiceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PersistedModelLocalServiceRegistryImpl.class);
    private final Map<String, PersistedModelLocalService> _persistedModelLocalServices = new ConcurrentHashMap<String, PersistedModelLocalService>();
    private final ServiceTracker<?, ?> _serviceTracker;

    public PersistedModelLocalServiceRegistryImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(registry.getFilter(StringBundler.concat("(&(model.class.name=*)(objectClass=", PersistedModelLocalService.class.getName(), "))")), new PersistenceModelLocalServiceServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    @Override
    public PersistedModelLocalService getPersistedModelLocalService(String className) {
        return this._persistedModelLocalServices.get(className);
    }

    @Override
    public List<PersistedModelLocalService> getPersistedModelLocalServices() {
        return ListUtil.fromMapValues(this._persistedModelLocalServices);
    }

    @Override
    @Deprecated
    public boolean isPermissionedModelLocalService(String className) {
        PersistedModelLocalService persistedModelLocalService = this.getPersistedModelLocalService(className);
        if (persistedModelLocalService == null) {
            return false;
        }
        return persistedModelLocalService instanceof PermissionedModelLocalService;
    }

    @Override
    public void register(String className, PersistedModelLocalService persistedModelLocalService) {
        PersistedModelLocalService oldPersistedModelLocalService = this._persistedModelLocalServices.put(className, persistedModelLocalService);
        if (oldPersistedModelLocalService != null && _log.isWarnEnabled()) {
            _log.warn("Duplicate class name " + className);
        }
    }

    @Override
    public void unregister(String className) {
        this._persistedModelLocalServices.remove(className);
    }

    private class PersistenceModelLocalServiceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PersistedModelLocalService, String> {
        private PersistenceModelLocalServiceServiceTrackerCustomizer() {
        }

        @Override
        public String addingService(ServiceReference<PersistedModelLocalService> serviceReference) {
            String className = (String)serviceReference.getProperty("model.class.name");
            Registry registry = RegistryUtil.getRegistry();
            PersistedModelLocalService persistedModelLocalService = registry.getService(serviceReference);
            PersistedModelLocalServiceRegistryImpl.this.register(className, persistedModelLocalService);
            return className;
        }

        @Override
        public void modifiedService(ServiceReference<PersistedModelLocalService> serviceReference, String className) {
            if (!Objects.equals(serviceReference.getProperty("model.class.name"), className)) {
                this.removedService(serviceReference, className);
                this.addingService((ServiceReference)serviceReference);
            }
        }

        @Override
        public void removedService(ServiceReference<PersistedModelLocalService> serviceReference, String className) {
            PersistedModelLocalServiceRegistryImpl.this.unregister(className);
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    }
}

