/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.pwd.BasicToolkit;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.util.PropsUtil;

public class RegExpToolkit
extends BasicToolkit {
    private static final Log _log = LogFactoryUtil.getLog(RegExpToolkit.class);
    private final String _charset;
    private final int _length;
    private final String _pattern = PropsUtil.get("passwords.regexptoolkit.pattern");

    public RegExpToolkit() {
        this._charset = PropsUtil.get("passwords.regexptoolkit.charset");
        this._length = GetterUtil.getInteger(PropsUtil.get("passwords.regexptoolkit.length"));
    }

    @Override
    public String generate(PasswordPolicy passwordPolicy) {
        return PwdGenerator.getPassword(this._charset, this._length);
    }

    @Override
    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        boolean value = password1.matches(this._pattern);
        if (!value) {
            if (_log.isWarnEnabled()) {
                _log.warn("User " + userId + " attempted an invalid password");
            }
            throw new UserPasswordException.MustComplyWithRegex(userId, this._pattern);
        }
    }
}

