/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2PasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final int _KEY_SIZE = 160;
    private static final int _ROUNDS = 128000;
    private static final int _SALT_BYTES_LENGTH = 8;
    private static final Pattern _pattern = Pattern.compile("^.*/?([0-9]+)?/([0-9]+)$");

    @Override
    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        try {
            PBKDF2EncryptionConfiguration pbkdf2EncryptionConfiguration = new PBKDF2EncryptionConfiguration();
            pbkdf2EncryptionConfiguration.configure(algorithm, encryptedPassword);
            byte[] saltBytes = pbkdf2EncryptionConfiguration.getSaltBytes();
            PBEKeySpec pbeKeySpec = new PBEKeySpec(plainTextPassword.toCharArray(), saltBytes, pbkdf2EncryptionConfiguration.getRounds(), pbkdf2EncryptionConfiguration.getKeySize());
            String algorithmName = algorithm;
            int index = algorithm.indexOf(47);
            if (index > -1) {
                algorithmName = algorithm.substring(0, index);
            }
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmName);
            SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
            byte[] secretKeyBytes = secretKey.getEncoded();
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 + saltBytes.length + secretKeyBytes.length);
            byteBuffer.putInt(pbkdf2EncryptionConfiguration.getKeySize());
            byteBuffer.putInt(pbkdf2EncryptionConfiguration.getRounds());
            byteBuffer.put(saltBytes);
            byteBuffer.put(secretKeyBytes);
            return Base64.encode(byteBuffer.array());
        }
        catch (Exception e) {
            throw new PwdEncryptorException(e.getMessage(), e);
        }
    }

    @Override
    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"PBKDF2"};
    }

    private static class PBKDF2EncryptionConfiguration {
        private int _keySize = 160;
        private int _rounds = 128000;
        private final byte[] _saltBytes = new byte[8];

        private PBKDF2EncryptionConfiguration() {
        }

        public void configure(String algorithm, String encryptedPassword) throws PwdEncryptorException {
            if (Validator.isNull(encryptedPassword)) {
                Matcher matcher = _pattern.matcher(algorithm);
                if (matcher.matches()) {
                    this._keySize = GetterUtil.getInteger(matcher.group(1), 160);
                    this._rounds = GetterUtil.getInteger(matcher.group(2), 128000);
                }
                BigEndianCodec.putLong(this._saltBytes, 0, SecureRandomUtil.nextLong());
            } else {
                ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.decode(encryptedPassword));
                try {
                    this._keySize = byteBuffer.getInt();
                    this._rounds = byteBuffer.getInt();
                    byteBuffer.get(this._saltBytes);
                }
                catch (BufferUnderflowException bue) {
                    throw new PwdEncryptorException("Unable to extract salt from encrypted password", bue);
                }
            }
        }

        public int getKeySize() {
            return this._keySize;
        }

        public int getRounds() {
            return this._rounds;
        }

        public byte[] getSaltBytes() {
            return this._saltBytes;
        }
    }
}

