/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission.test.util;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RoleTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.service.test.ServiceTestUtil;
import java.util.Map;
import org.junit.After;
import org.junit.Before;

public abstract class BasePermissionTestCase {
    @DeleteAfterTestRun
    protected Group group;
    protected PermissionChecker permissionChecker;
    protected ServiceContext serviceContext;
    @DeleteAfterTestRun
    protected User user;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        this.user = UserTestUtil.addUser();
        this.serviceContext = ServiceContextTestUtil.getServiceContext(this.group.getGroupId());
        this.doSetUp();
        ServiceTestUtil.setUser(this.user);
        this.permissionChecker = PermissionThreadLocal.getPermissionChecker();
        this.addPortletModelViewPermission();
    }

    @After
    public void tearDown() throws Exception {
        ServiceTestUtil.setUser(TestPropsValues.getUser());
        this.removePortletModelViewPermission();
    }

    protected void addPortletModelViewPermission() throws Exception {
        RoleTestUtil.addResourcePermission(this.getRoleName(), this.getResourceName(), 2, this.getPrimKey(), "VIEW");
        Role role = RoleLocalServiceUtil.getRole(TestPropsValues.getCompanyId(), this.getRoleName());
        ResourcePermissionLocalServiceUtil.setResourcePermissions(this.group.getCompanyId(), this.getResourceName(), 4, this.getPrimKey(), role.getRoleId(), new String[]{"VIEW"});
    }

    protected abstract void doSetUp() throws Exception;

    protected String getPrimKey() {
        return String.valueOf(this.group.getGroupId());
    }

    protected abstract String getResourceName();

    protected String getRoleName() {
        return "Guest";
    }

    protected void removePortletModelViewPermission() throws Exception {
        RoleTestUtil.removeResourcePermission(this.getRoleName(), this.getResourceName(), 2, this.getPrimKey(), "VIEW");
        RoleTestUtil.removeResourcePermission(this.getRoleName(), this.getResourceName(), 4, this.getPrimKey(), "VIEW");
        Map<Object, Object> permissionChecksMap = this.permissionChecker.getPermissionChecksMap();
        permissionChecksMap.clear();
    }
}

