/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactory;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.UserBagImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class UserBagFactoryImpl
implements UserBagFactory {
    @Override
    public UserBag create(long userId) throws PortalException {
        UserBag userBag = PermissionCacheUtil.getUserBag(userId);
        if (userBag != null) {
            return userBag;
        }
        try {
            HashSet<Long> allGroupIds = new HashSet<Long>();
            Collection<Organization> userOrgs = this.getUserOrgs(userId);
            HashSet<Long> userOrgGroupIds = new HashSet<Long>(userOrgs.size());
            for (Organization organization : userOrgs) {
                userOrgGroupIds.add(organization.getGroupId());
            }
            allGroupIds.addAll(userOrgGroupIds);
            List<UserGroup> userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups(userId);
            long[] userUserGroupGroupIds = new long[userUserGroups.size()];
            for (int i = 0; i < userUserGroups.size(); ++i) {
                long groupId;
                UserGroup userUserGroup = userUserGroups.get(i);
                userUserGroupGroupIds[i] = groupId = userUserGroup.getGroupId();
                allGroupIds.add(groupId);
            }
            long[] userGroupIds = null;
            if (userOrgs.isEmpty() && userUserGroups.isEmpty()) {
                userGroupIds = UserLocalServiceUtil.getGroupPrimaryKeys(userId);
            } else {
                List<Group> userGroups = GroupLocalServiceUtil.getUserGroups(userId, true);
                userGroupIds = new long[userGroups.size()];
                for (int i = 0; i < userGroups.size(); ++i) {
                    long groupId;
                    Group userGroup = userGroups.get(i);
                    userGroupIds[i] = groupId = userGroup.getGroupId();
                    allGroupIds.add(groupId);
                }
            }
            if (allGroupIds.isEmpty()) {
                long[] userRoleIds = UserLocalServiceUtil.getRolePrimaryKeys(userId);
                userBag = new UserBagImpl(userId, userGroupIds, userOrgs, userOrgGroupIds, userUserGroups, userUserGroupGroupIds, userRoleIds);
            } else {
                List<Role> userRoles = RoleLocalServiceUtil.getUserRelatedRoles(userId, ArrayUtil.toLongArray(allGroupIds));
                userBag = new UserBagImpl(userId, userGroupIds, userOrgs, userOrgGroupIds, userUserGroups, userUserGroupGroupIds, userRoles);
            }
            PermissionCacheUtil.putUserBag(userId, userBag);
            return userBag;
        }
        catch (Exception e) {
            PermissionCacheUtil.removeUserBag(userId);
            throw e;
        }
    }

    protected Collection<Organization> getUserOrgs(long userId) throws PortalException {
        List<Organization> userOrgs = OrganizationLocalServiceUtil.getUserOrganizations(userId);
        if (userOrgs.isEmpty()) {
            return Collections.emptyList();
        }
        if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
            return userOrgs;
        }
        LinkedHashSet<Organization> organizations = new LinkedHashSet<Organization>();
        for (Organization organization : userOrgs) {
            if (!organizations.add(organization)) continue;
            List<Organization> ancestorOrganizations = OrganizationLocalServiceUtil.getParentOrganizations(organization.getOrganizationId());
            organizations.addAll(ancestorOrganizations);
        }
        return organizations;
    }
}

