/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.model.impl.ResourcePermissionModelImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;

public class ResourcePermissionModelListener
extends BaseModelListener<ResourcePermission> {
    private static final long _CLEAR_ON_BEFORE_BITMASK = 6L;

    @Override
    public void onAfterCreate(ResourcePermission resourcePermission) {
        this._clearCache(resourcePermission);
    }

    @Override
    public void onAfterRemove(ResourcePermission resourcePermission) {
        this._clearCache(resourcePermission);
    }

    @Override
    public void onAfterUpdate(ResourcePermission resourcePermission) {
        this._clearCache(resourcePermission);
    }

    @Override
    public void onBeforeUpdate(ResourcePermission resourcePermission) {
        ResourcePermissionModelImpl resourcePermissionModelImpl = (ResourcePermissionModelImpl)((Object)resourcePermission);
        long columnBitmask = resourcePermissionModelImpl.getColumnBitmask();
        if ((columnBitmask & 6L) != 0L) {
            PermissionCacheUtil.clearResourcePermissionCache(resourcePermissionModelImpl.getOriginalScope(), resourcePermissionModelImpl.getOriginalName(), resourcePermissionModelImpl.getOriginalPrimKey());
        }
    }

    private void _clearCache(ResourcePermission resourcePermission) {
        if (resourcePermission != null) {
            PermissionCacheUtil.clearResourcePermissionCache(resourcePermission.getScope(), resourcePermission.getName(), resourcePermission.getPrimKey());
        }
    }
}

