/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;

public abstract class DoAsUserThread
extends Thread {
    private static final Log _log = LogFactoryUtil.getLog(DoAsUserThread.class);
    private final int _retries;
    private boolean _success;
    private final long _userId;

    public DoAsUserThread(long userId) {
        this(userId, 1);
    }

    public DoAsUserThread(long userId, int retries) {
        this._userId = userId;
        this._retries = retries;
    }

    public boolean isSuccess() {
        return this._success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = 0; i < this._retries; ++i) {
            try {
                User user = UserLocalServiceUtil.getUserById(this._userId);
                CompanyThreadLocal.setCompanyId(user.getCompanyId());
                PrincipalThreadLocal.setName(this._userId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
                PermissionThreadLocal.setPermissionChecker(permissionChecker);
                this.doRun();
                this._success = true;
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                continue;
            }
            finally {
                PrincipalThreadLocal.setName(null);
                PermissionThreadLocal.setPermissionChecker(null);
            }
        }
    }

    protected abstract void doRun() throws Exception;
}

