/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BasePermissionChecker
implements PermissionChecker {
    protected boolean checkGuest = PropsValues.PERMISSIONS_CHECK_GUEST_ENABLED;
    protected long defaultUserId;
    protected Boolean omniadmin;
    protected Role ownerRole;
    protected boolean signedIn;
    protected User user;
    private static final Log _log = LogFactoryUtil.getLog(BasePermissionChecker.class);
    private final Map<Object, Object> _permissionChecksMap = new HashMap<Object, Object>();

    @Override
    public abstract PermissionChecker clone();

    @Override
    public long getCompanyId() {
        return this.user.getCompanyId();
    }

    @Override
    public long[] getGuestUserRoleIds() {
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    @Override
    @Deprecated
    public List<Long> getOwnerResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        return Collections.emptyList();
    }

    @Override
    public long getOwnerRoleId() {
        return this.ownerRole.getRoleId();
    }

    @Override
    public Map<Object, Object> getPermissionChecksMap() {
        return this._permissionChecksMap;
    }

    @Override
    @Deprecated
    public List<Long> getResourceBlockIds(long companyId, long groupId, long userId, String name, String actionId) {
        return Collections.emptyList();
    }

    @Override
    public long[] getRoleIds(long userId, long groupId) {
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public long getUserId() {
        return this.user.getUserId();
    }

    @Override
    public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
        return this.hasOwnerPermission(companyId, name, String.valueOf(primKey), ownerId, actionId);
    }

    @Override
    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        return this.hasPermission(group, name, String.valueOf(primKey), actionId);
    }

    @Override
    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this.hasPermission(GroupLocalServiceUtil.fetchGroup(groupId), name, String.valueOf(primKey), actionId);
    }

    @Override
    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        return this.hasPermission(GroupLocalServiceUtil.fetchGroup(groupId), name, primKey, actionId);
    }

    @Override
    public void init(User user) {
        this.user = user;
        if (user.isDefaultUser()) {
            this.defaultUserId = user.getUserId();
            this.signedIn = false;
        } else {
            try {
                this.defaultUserId = UserLocalServiceUtil.getDefaultUserId(user.getCompanyId());
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            this.signedIn = true;
        }
        try {
            this.ownerRole = RoleLocalServiceUtil.getRole(user.getCompanyId(), "Owner");
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public boolean isCheckGuest() {
        return this.checkGuest;
    }

    @Override
    public boolean isOmniadmin() {
        if (this.omniadmin == null) {
            this.omniadmin = OmniadminUtil.isOmniadmin(this.getUser());
        }
        return this.omniadmin;
    }

    @Override
    public boolean isSignedIn() {
        return this.signedIn;
    }
}

