/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;

public class SiteMembershipPolicyFactoryImpl
implements SiteMembershipPolicyFactory {
    private static final Log _log = LogFactoryUtil.getLog(SiteMembershipPolicyFactoryImpl.class);
    private static final SiteMembershipPolicyFactoryImpl _instance = new SiteMembershipPolicyFactoryImpl();
    private final ServiceTracker<?, SiteMembershipPolicy> _serviceTracker;

    @Override
    public SiteMembershipPolicy getSiteMembershipPolicy() {
        return SiteMembershipPolicyFactoryImpl._instance._serviceTracker.getService();
    }

    private SiteMembershipPolicyFactoryImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(SiteMembershipPolicy.class, new SiteMembershipPolicyTrackerCustomizer());
        this._serviceTracker.open();
    }

    private static class SiteMembershipPolicyTrackerCustomizer
    implements ServiceTrackerCustomizer<SiteMembershipPolicy, SiteMembershipPolicy> {
        private SiteMembershipPolicyTrackerCustomizer() {
        }

        @Override
        public SiteMembershipPolicy addingService(ServiceReference<SiteMembershipPolicy> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SiteMembershipPolicy siteMembershipPolicy = registry.getService(serviceReference);
            if (PropsValues.MEMBERSHIP_POLICY_AUTO_VERIFY) {
                try {
                    siteMembershipPolicy.verifyPolicy();
                }
                catch (PortalException pe) {
                    _log.error(pe, pe);
                }
            }
            return siteMembershipPolicy;
        }

        @Override
        public void modifiedService(ServiceReference<SiteMembershipPolicy> serviceReference, SiteMembershipPolicy siteMembershipPolicy) {
        }

        @Override
        public void removedService(ServiceReference<SiteMembershipPolicy> serviceReference, SiteMembershipPolicy siteMembershipPolicy) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    }
}

