/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicyFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;

public class RoleMembershipPolicyFactoryImpl
implements RoleMembershipPolicyFactory {
    private static final Log _log = LogFactoryUtil.getLog(RoleMembershipPolicyFactoryImpl.class);
    private static final RoleMembershipPolicyFactoryImpl _instance = new RoleMembershipPolicyFactoryImpl();
    private final ServiceTracker<?, RoleMembershipPolicy> _serviceTracker;

    @Override
    public RoleMembershipPolicy getRoleMembershipPolicy() {
        return RoleMembershipPolicyFactoryImpl._instance._serviceTracker.getService();
    }

    private RoleMembershipPolicyFactoryImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(RoleMembershipPolicy.class, new RoleMembershipPolicyTrackerCustomizer());
        this._serviceTracker.open();
    }

    private static class RoleMembershipPolicyTrackerCustomizer
    implements ServiceTrackerCustomizer<RoleMembershipPolicy, RoleMembershipPolicy> {
        private RoleMembershipPolicyTrackerCustomizer() {
        }

        @Override
        public RoleMembershipPolicy addingService(ServiceReference<RoleMembershipPolicy> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            RoleMembershipPolicy roleMembershipPolicy = registry.getService(serviceReference);
            if (PropsValues.MEMBERSHIP_POLICY_AUTO_VERIFY) {
                try {
                    roleMembershipPolicy.verifyPolicy();
                }
                catch (PortalException pe) {
                    _log.error(pe, pe);
                }
            }
            return roleMembershipPolicy;
        }

        @Override
        public void modifiedService(ServiceReference<RoleMembershipPolicy> serviceReference, RoleMembershipPolicy roleMembershipPolicy) {
        }

        @Override
        public void removedService(ServiceReference<RoleMembershipPolicy> serviceReference, RoleMembershipPolicy roleMembershipPolicy) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    }
}

