/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.BaseSiteMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultSiteMembershipPolicy
extends BaseSiteMembershipPolicy {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSiteMembershipPolicy.class);

    @Override
    public void checkMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException {
        if (addGroupIds != null) {
            this.checkAddUsersLimitedGroup(userIds, addGroupIds);
        }
    }

    @Override
    public boolean isMembershipAllowed(long userId, long groupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            if (group.isLimitedToParentSiteMembers() && !GroupLocalServiceUtil.hasUserGroup(userId, group.getParentGroupId(), false)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return true;
    }

    @Override
    public void propagateMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException {
        if (removeGroupIds != null) {
            for (long removeGroupId : removeGroupIds) {
                this.removeUsersFromLimitedChildrenGroups(userIds, removeGroupId);
            }
        }
    }

    @Override
    public void verifyPolicy(Group group) throws PortalException {
        if (group.isLimitedToParentSiteMembers()) {
            this.verifyLimitedParentMembership(group);
        }
    }

    @Override
    public void verifyPolicy(Group group, Group oldGroup, List<AssetCategory> oldAssetCategories, List<AssetTag> oldAssetTags, Map<String, Serializable> oldExpandoAttributes, UnicodeProperties oldTypeSettingsProperties) throws PortalException {
        if (group.isLimitedToParentSiteMembers()) {
            if (group.getParentGroupId() == oldGroup.getParentGroupId() && oldGroup.isLimitedToParentSiteMembers()) {
                this.verifyPolicy(group);
            } else {
                List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
                for (Group childrenGroup : childrenGroups) {
                    this.verifyPolicy(childrenGroup);
                }
            }
        }
    }

    protected void checkAddUsersLimitedGroup(long[] userIds, long[] groupIds) throws PortalException {
        MembershipPolicyException membershipPolicyException = null;
        for (long groupId : groupIds) {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            if (!group.isLimitedToParentSiteMembers()) continue;
            for (long userId : userIds) {
                if (GroupLocalServiceUtil.hasUserGroup(userId, group.getParentGroupId(), false)) continue;
                if (membershipPolicyException == null) {
                    membershipPolicyException = new MembershipPolicyException(5);
                }
                User user = UserLocalServiceUtil.getUser(userId);
                membershipPolicyException.addUser(user);
            }
            if (membershipPolicyException == null) continue;
            membershipPolicyException.addGroup(group);
        }
        if (membershipPolicyException != null) {
            throw membershipPolicyException;
        }
    }

    protected List<Group> getLimitedChildrenGroups(Group group) throws PortalException {
        ArrayList<Group> parentGroups = new ArrayList<Group>();
        parentGroups.add(group);
        LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
        groupParams.put("groupsTree", parentGroups);
        groupParams.put("membershipRestriction", 1);
        groupParams.put("site", Boolean.TRUE);
        List<Group> childrenGroups = GroupLocalServiceUtil.search(group.getCompanyId(), null, "", groupParams, -1, -1);
        List<Group> filteredChildrenGroups = ListUtil.copy(childrenGroups);
        block0: for (Group childrenGroup : childrenGroups) {
            for (Group ancestorGroup : childrenGroup.getAncestors()) {
                if (ancestorGroup.getGroupId() == group.getGroupId() || ancestorGroup.isLimitedToParentSiteMembers()) continue;
                filteredChildrenGroups.remove(childrenGroup);
                continue block0;
            }
        }
        return filteredChildrenGroups;
    }

    protected void removeUsersFromLimitedChildrenGroups(long[] userIds, long groupId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
        for (Group childrenGroup : childrenGroups) {
            if (!childrenGroup.isLimitedToParentSiteMembers()) continue;
            for (long userId : userIds) {
                UserLocalServiceUtil.unsetGroupUsers(childrenGroup.getGroupId(), new long[]{userId}, null);
            }
        }
    }

    protected void verifyLimitedParentMembership(final Group group) throws PortalException {
        int total = UserLocalServiceUtil.getGroupUsersCount(group.getGroupId());
        final IntervalActionProcessor<Void> intervalActionProcessor = new IntervalActionProcessor<Void>(total);
        intervalActionProcessor.setPerformIntervalActionMethod(new IntervalActionProcessor.PerformIntervalActionMethod<Void>(){

            @Override
            public Void performIntervalAction(int start, int end) throws PortalException {
                List<User> users = UserLocalServiceUtil.getGroupUsers(group.getGroupId(), start, end);
                for (User user : users) {
                    if (!UserLocalServiceUtil.hasGroupUser(group.getParentGroupId(), user.getUserId())) {
                        UserLocalServiceUtil.unsetGroupUsers(group.getGroupId(), new long[]{user.getUserId()}, null);
                        continue;
                    }
                    intervalActionProcessor.incrementStart();
                }
                return null;
            }
        });
        intervalActionProcessor.performIntervalActions();
    }
}

