/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.util;

import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringEscapeUtils;

public class LDAPUtil {
    private static final String[] _INVALID_CHARS = new String[]{">", "<", "+", "#", "\"", ";"};
    private static final String[] _INVALID_CHARS_SUBS = new String[]{"\\\\".concat(">"), "\\\\".concat("<"), "\\\\".concat("+"), "\\\\".concat("#"), "\\\\".concat("\""), "\\\\".concat(";")};

    public static String escapeCharacters(String attribute) {
        if (attribute.contains("\\")) {
            String escapedSingleBackSlash = "\\\\".concat("\\");
            attribute = attribute.replace("\\", escapedSingleBackSlash);
        } else {
            attribute = StringEscapeUtils.escapeJava((String)attribute);
        }
        return StringUtil.replace(attribute, _INVALID_CHARS, _INVALID_CHARS_SUBS);
    }

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id);
    }

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key, Object defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id, defaultValue);
    }

    public static Object getAttributeObject(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeObject(attributes, id, null);
    }

    public static Object getAttributeObject(Attributes attributes, String id, Object defaultValue) throws NamingException {
        if (Validator.isNull(id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object;
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id);
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key, String defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id, defaultValue);
    }

    public static String getAttributeString(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeString(attributes, id, "");
    }

    public static String getAttributeString(Attributes attributes, String id, String defaultValue) throws NamingException {
        if (Validator.isNull(id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static String[] getAttributeStringArray(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeStringArray(attributes, id);
    }

    public static String[] getAttributeStringArray(Attributes attributes, String id) throws NamingException {
        if (Validator.isNull(id)) {
            return null;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return new String[0];
        }
        int size = attribute.size();
        if (size == 0) {
            return null;
        }
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            Object object = attribute.get(i);
            array[i] = object == null ? "" : object.toString();
        }
        return array;
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return baseURL + "/" + baseDN;
    }

    public static Date parseDate(String date) throws Exception {
        if (Validator.isNull(date)) {
            return null;
        }
        String format = "yyyyMMddHHmmss";
        if (date.endsWith("Z")) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.S'Z'" : "yyyyMMddHHmmss'Z'";
        } else if (date.indexOf(45) != -1 || date.indexOf(43) != -1) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.SSSZ" : "yyyyMMddHHmmssZ";
        } else if (date.indexOf(46) != -1) {
            format = "yyyyMMddHHmmss.S";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat(format);
        return dateFormat.parse(date);
    }
}

