/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.jaas.ext.jonas;

import com.liferay.petra.lang.ClassResolverUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.jaas.ext.BasicLoginModule;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class PortalLoginModule
extends BasicLoginModule {
    private static final String _JGROUP = "org.objectweb.jonas.security.auth.JGroup";
    private static final String _JPRINCIPAL = "org.objectweb.jonas.security.auth.JPrincipal";
    private static final String _JROLE = "org.objectweb.jonas.security.auth.JRole";
    private static final Log _log = LogFactoryUtil.getLog(PortalLoginModule.class);

    @Override
    public boolean commit() throws LoginException {
        boolean commitValue = super.commit();
        if (!commitValue) {
            return false;
        }
        Subject subject = this.getSubject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(this.getPrincipal());
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        privateCredentials.add(this.getPassword());
        try {
            Principal group = (Principal)InstanceFactory.newInstance(_JGROUP, String.class, "Roles");
            Object role = InstanceFactory.newInstance(_JROLE, String.class, "users");
            Thread thread = Thread.currentThread();
            MethodKey methodKey = new MethodKey(ClassResolverUtil.resolve(_JGROUP, thread.getContextClassLoader()), "addMember", role.getClass());
            Method method = methodKey.getMethod();
            method.invoke((Object)group, role);
            principals.add(group);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return commitValue;
    }

    @Override
    protected Principal getPortalPrincipal(String name) throws LoginException {
        try {
            return (Principal)InstanceFactory.newInstance(_JPRINCIPAL, String.class, name);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }
}

