/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManager;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import com.liferay.portal.util.PortalInstances;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpAuthManagerImpl
implements HttpAuthManager {
    private static final Log _log = LogFactoryUtil.getLog(HttpAuthManagerImpl.class);

    @Override
    public void generateChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        String scheme;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        if (httpServletResponse == null) {
            throw new IllegalArgumentException("HTTP servlet response is null");
        }
        if (httpAuthorizationHeader == null || Validator.isBlank(httpAuthorizationHeader.getScheme())) {
            throw new IllegalArgumentException("HTTP authorization header scheme is null");
        }
        String realm = httpAuthorizationHeader.getAuthParameter("realm");
        if (Validator.isBlank(realm)) {
            httpAuthorizationHeader.setAuthParameter("realm", "PortalRealm");
        }
        if (StringUtil.equalsIgnoreCase(scheme = httpAuthorizationHeader.getScheme(), "Basic")) {
            this.generateBasicChallenge(httpServletRequest, httpServletResponse, httpAuthorizationHeader);
        } else if (StringUtil.equalsIgnoreCase(scheme, "Digest")) {
            this.generateDigestChallenge(httpServletRequest, httpServletResponse, httpAuthorizationHeader);
        } else {
            throw new UnsupportedOperationException("Scheme " + scheme);
        }
    }

    @Override
    public long getBasicUserId(HttpServletRequest httpServletRequest) throws PortalException {
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse(httpServletRequest);
        if (httpAuthorizationHeader == null) {
            return 0L;
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (!StringUtil.equalsIgnoreCase(scheme, "Basic")) {
            return 0L;
        }
        return this.getUserId(httpServletRequest, httpAuthorizationHeader);
    }

    @Override
    public long getDigestUserId(HttpServletRequest httpServletRequest) throws PortalException {
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse(httpServletRequest);
        if (httpAuthorizationHeader == null) {
            return 0L;
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (!StringUtil.equalsIgnoreCase(scheme, "Digest")) {
            return 0L;
        }
        return this.getUserId(httpServletRequest, httpAuthorizationHeader);
    }

    @Override
    public long getUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        if (httpAuthorizationHeader == null || Validator.isBlank(httpAuthorizationHeader.getScheme())) {
            throw new IllegalArgumentException("HTTP authorization header scheme is null");
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (StringUtil.equalsIgnoreCase(scheme, "Basic")) {
            return this.getBasicUserId(httpServletRequest, httpAuthorizationHeader);
        }
        if (StringUtil.equalsIgnoreCase(scheme, "Digest")) {
            return this.getDigestUserId(httpServletRequest, httpAuthorizationHeader);
        }
        throw new UnsupportedOperationException("Scheme " + scheme);
    }

    @Override
    public HttpAuthorizationHeader parse(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        String authorization = httpServletRequest.getHeader("Authorization");
        if (Validator.isBlank(authorization)) {
            return null;
        }
        String[] authorizationParts = authorization.split("\\s");
        String scheme = authorizationParts[0];
        if (StringUtil.equalsIgnoreCase(scheme, "Basic")) {
            return this.parseBasic(httpServletRequest, authorization, authorizationParts);
        }
        if (StringUtil.equalsIgnoreCase(scheme, "Digest")) {
            return this.parseDigest(httpServletRequest, authorization, authorizationParts);
        }
        throw new UnsupportedOperationException("Scheme " + scheme);
    }

    protected void generateBasicChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        httpServletResponse.setHeader("WWW-Authenticate", httpAuthorizationHeader.toString());
        httpServletResponse.setStatus(401);
    }

    protected void generateDigestChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        long companyId = PortalInstances.getCompanyId(httpServletRequest);
        String remoteAddress = httpServletRequest.getRemoteAddr();
        String nonce = NonceUtil.generate(companyId, remoteAddress);
        httpAuthorizationHeader.setAuthParameter("nonce", nonce);
        httpServletResponse.setHeader("WWW-Authenticate", httpAuthorizationHeader.toString());
        httpServletResponse.setStatus(401);
    }

    protected long getBasicUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        int pos;
        String login = httpAuthorizationHeader.getAuthParameter("username");
        if (login.endsWith("@uid")) {
            pos = login.indexOf("@uid");
            login = login.substring(0, pos);
        } else if (login.endsWith("@sn")) {
            pos = login.indexOf("@sn");
            login = login.substring(0, pos);
        }
        try {
            String password = httpAuthorizationHeader.getAuthParameter("password");
            return AuthenticatedSessionManagerUtil.getAuthenticatedUserId(httpServletRequest, login, password, null);
        }
        catch (AuthException ae) {
            if (_log.isDebugEnabled()) {
                _log.debug(ae, ae);
            }
            return 0L;
        }
    }

    protected long getDigestUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        long userId = 0L;
        String username = httpAuthorizationHeader.getAuthParameter("username");
        String realm = httpAuthorizationHeader.getAuthParameter("realm");
        String nonce = httpAuthorizationHeader.getAuthParameter("nonce");
        String uri = httpAuthorizationHeader.getAuthParameter("uri");
        String response = httpAuthorizationHeader.getAuthParameter("response");
        if (Validator.isNull(username) || Validator.isNull(realm) || Validator.isNull(nonce) || Validator.isNull(uri) || Validator.isNull(response)) {
            return userId;
        }
        String requestURI = httpServletRequest.getRequestURI();
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNotNull(queryString)) {
            requestURI = requestURI.concat("?").concat(queryString);
        }
        if (!realm.equals("PortalRealm") || !uri.equals(requestURI)) {
            return userId;
        }
        if (!NonceUtil.verify(nonce)) {
            return userId;
        }
        long companyId = PortalInstances.getCompanyId(httpServletRequest);
        userId = UserLocalServiceUtil.authenticateForDigest(companyId, username, realm, nonce, httpServletRequest.getMethod(), uri, response);
        return userId;
    }

    protected HttpAuthorizationHeader parseBasic(HttpServletRequest httpServletRequest, String authorization, String[] authorizationParts) {
        String credentials = new String(Base64.decode(authorizationParts[1]));
        String login = null;
        String password = null;
        int index = credentials.indexOf(58);
        if (index > -1) {
            login = credentials.substring(0, index);
            login = HttpUtil.decodeURL(login.trim());
            password = credentials.substring(index + 1);
            password = password.trim();
        } else {
            login = credentials.trim();
        }
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
        httpAuthorizationHeader.setAuthParameter("username", login);
        httpAuthorizationHeader.setAuthParameter("password", password);
        return httpAuthorizationHeader;
    }

    protected HttpAuthorizationHeader parseDigest(HttpServletRequest httpServletRequest, String authorization, String[] authorizationHeaderParts) {
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
        authorization = authorization.substring("Digest".length() + 1);
        authorization = StringUtil.replace(authorization, ',', '\n');
        UnicodeProperties authorizationProperties = new UnicodeProperties();
        authorizationProperties.fastLoad(authorization);
        for (Map.Entry authorizationProperty : authorizationProperties.entrySet()) {
            String key = (String)authorizationProperty.getKey();
            String value = StringUtil.unquote(authorizationProperties.getProperty(key));
            httpAuthorizationHeader.setAuthParameter(key, value);
        }
        return httpAuthorizationHeader;
    }
}

