/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class StrutsPortletAuthTokenWhitelist
extends BaseAuthTokenWhitelist {
    private static final Log _log = LogFactoryUtil.getLog(StrutsPortletAuthTokenWhitelist.class);
    private final Set<String> _portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());

    public StrutsPortletAuthTokenWhitelist() {
        this.trackWhitelistServices("auth.token.ignore.actions", this._portletCSRFWhitelist);
        this.registerPortalProperty("auth.token.ignore.actions");
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.actions", this._portletInvocationWhitelist);
        this.registerPortalProperty("portlet.add.default.resource.check.whitelist.actions");
    }

    @Override
    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String namespace = PortalUtil.getPortletNamespace(portletId);
        String strutsAction = httpServletRequest.getParameter(namespace.concat("struts_action"));
        return Validator.isNotNull(strutsAction) && this._portletCSRFWhitelist.contains(strutsAction) && this.isValidStrutsAction(portlet.getCompanyId(), PortletIdCodec.decodePortletName(portletId), strutsAction);
    }

    @Override
    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String namespace = PortalUtil.getPortletNamespace(portletId);
        String strutsAction = httpServletRequest.getParameter(namespace.concat("struts_action"));
        if (Validator.isNull(strutsAction)) {
            strutsAction = httpServletRequest.getParameter("struts_action");
        }
        return Validator.isNotNull(strutsAction) && this._portletInvocationWhitelist.contains(strutsAction) && this.isValidStrutsAction(portlet.getCompanyId(), portletId, strutsAction);
    }

    @Override
    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String strutsAction = liferayPortletURL.getParameter("struts_action");
        if (Validator.isBlank(strutsAction)) {
            return false;
        }
        if (this._portletCSRFWhitelist.contains(strutsAction)) {
            long plid = liferayPortletURL.getPlid();
            Layout layout = LayoutLocalServiceUtil.fetchLayout(plid);
            if (layout == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to load layout " + plid);
                }
                return false;
            }
            String portletId = liferayPortletURL.getPortletId();
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            if (this.isValidStrutsAction(0L, rootPortletId, strutsAction)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        String strutsAction = liferayPortletURL.getParameter("struts_action");
        if (Validator.isBlank(strutsAction)) {
            return false;
        }
        if (this._portletInvocationWhitelist.contains(strutsAction)) {
            long plid = liferayPortletURL.getPlid();
            Layout layout = LayoutLocalServiceUtil.fetchLayout(plid);
            if (layout == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to load layout " + plid);
                }
                return false;
            }
            String portletId = liferayPortletURL.getPortletId();
            if (this.isValidStrutsAction(0L, portletId, strutsAction)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidStrutsAction(long companyId, String portletId, String strutsAction) {
        block4: {
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
                if (portlet == null) {
                    return false;
                }
                String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
                if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(e, e);
            }
        }
        return false;
    }
}

