/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthToken;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.SecurityPortletContainerWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _CSRF = "#CSRF";
    private static final Log _log = LogFactoryUtil.getLog(SessionAuthToken.class);

    @Override
    public void addCSRFToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String lifecycle = liferayPortletURL.getLifecycle();
        if (!lifecycle.equals("ACTION_PHASE")) {
            return;
        }
        if (AuthTokenWhitelistUtil.isPortletURLCSRFWhitelisted(liferayPortletURL)) {
            return;
        }
        liferayPortletURL.setParameter("p_auth", this.getToken(httpServletRequest));
    }

    @Override
    public void addPortletInvocationToken(HttpServletRequest httpServletRequest, LiferayPortletURL liferayPortletURL) {
        long plid;
        String portletId;
        block7: {
            if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
                return;
            }
            long companyId = PortalUtil.getCompanyId(httpServletRequest);
            Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId = liferayPortletURL.getPortletId());
            if (portlet == null) {
                return;
            }
            if (!portlet.isAddDefaultResource()) {
                return;
            }
            if (AuthTokenWhitelistUtil.isPortletURLPortletInvocationWhitelisted(liferayPortletURL)) {
                return;
            }
            plid = liferayPortletURL.getPlid();
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout(plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasPortletId(portletId)) {
                    return;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug(e.getMessage(), e);
            }
        }
        liferayPortletURL.setParameter("p_p_auth", this.getToken(httpServletRequest, plid, portletId));
    }

    @Override
    public void checkCSRFToken(HttpServletRequest httpServletRequest, String origin) throws PrincipalException {
        String sessionToken;
        String ppid;
        Portlet portlet;
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String sharedSecret = ParamUtil.getString(httpServletRequest, "p_auth_secret");
        if (AuthTokenWhitelistUtil.isValidSharedSecret(sharedSecret)) {
            return;
        }
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        if (AuthTokenWhitelistUtil.isOriginCSRFWhitelisted(companyId, origin)) {
            return;
        }
        if (origin.equals(SecurityPortletContainerWrapper.class.getName()) && AuthTokenWhitelistUtil.isPortletCSRFWhitelisted(httpServletRequest, portlet = PortletLocalServiceUtil.getPortletById(companyId, ppid = ParamUtil.getString(httpServletRequest, "p_p_id")))) {
            return;
        }
        String csrfToken = ParamUtil.getString(httpServletRequest, "p_auth");
        if (Validator.isNull(csrfToken)) {
            csrfToken = GetterUtil.getString(httpServletRequest.getHeader("X-CSRF-Token"));
        }
        if (!csrfToken.equals(sessionToken = this.getSessionAuthenticationToken(httpServletRequest, _CSRF, false))) {
            throw new PrincipalException.MustHaveValidCSRFToken(PortalUtil.getUserId(httpServletRequest), origin);
        }
    }

    @Override
    public String getToken(HttpServletRequest httpServletRequest) {
        return this.getSessionAuthenticationToken(httpServletRequest, _CSRF, true);
    }

    @Override
    public String getToken(HttpServletRequest httpServletRequest, long plid, String portletId) {
        return this.getSessionAuthenticationToken(httpServletRequest, PortletPermissionUtil.getPrimaryKey(plid, portletId), true);
    }

    @Override
    public boolean isValidPortletInvocationToken(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        String key;
        String sessionToken;
        if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted(httpServletRequest, portlet)) {
            return true;
        }
        String portletToken = ParamUtil.getString(httpServletRequest, "p_p_auth");
        if (Validator.isNull(portletToken)) {
            HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(httpServletRequest);
            portletToken = ParamUtil.getString(originalHttpServletRequest, "p_p_auth");
        }
        return Validator.isNotNull(portletToken) && Validator.isNotNull(sessionToken = this.getSessionAuthenticationToken(httpServletRequest, key = PortletPermissionUtil.getPrimaryKey(layout.getPlid(), portlet.getPortletId()), false)) && sessionToken.equals(portletToken);
    }

    protected String getSessionAuthenticationToken(HttpServletRequest httpServletRequest, String key, boolean createToken) {
        String sessionAuthenticationToken = null;
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        HttpSession session = null;
        String tokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper && !Validator.isNotNull(sessionAuthenticationToken = (String)(session = currentHttpServletRequest.getSession()).getAttribute(tokenKey))) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (session == null) {
            session = currentHttpServletRequest.getSession();
            sessionAuthenticationToken = (String)session.getAttribute(tokenKey);
        }
        if (createToken && Validator.isNull(sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword(PropsValues.AUTH_TOKEN_LENGTH);
            session.setAttribute(tokenKey, (Object)sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }
}

