/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class MVCPortletAuthTokenWhitelist
extends BaseAuthTokenWhitelist {
    private final Set<String> _portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelistAction = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelistRender = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelistResource = Collections.newSetFromMap(new ConcurrentHashMap());

    public MVCPortletAuthTokenWhitelist() {
        this.trackWhitelistServices("auth.token.ignore.mvc.action", MVCActionCommand.class, this._portletCSRFWhitelist);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCActionCommand.class, this._portletInvocationWhitelistAction);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCRenderCommand.class, this._portletInvocationWhitelistRender);
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.mvc.action", MVCResourceCommand.class, this._portletInvocationWhitelistResource);
    }

    @Override
    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String[] mvcActionCommandNames = this.getMVCActionCommandNames(httpServletRequest, portletId);
        return this._containsAll(portletId, this._portletCSRFWhitelist, mvcActionCommandNames);
    }

    @Override
    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isLifecycleAction()) {
            String[] mvcActionCommandNames = this.getMVCActionCommandNames(httpServletRequest, portletId);
            return this._containsAll(portletId, this._portletInvocationWhitelistAction, mvcActionCommandNames);
        }
        if (themeDisplay.isLifecycleRender()) {
            String namespace = PortalUtil.getPortletNamespace(portletId);
            String mvcRenderCommandName = httpServletRequest.getParameter(namespace.concat("mvcRenderCommandName"));
            return this._contains(portletId, this._portletInvocationWhitelistRender, mvcRenderCommandName);
        }
        if (themeDisplay.isLifecycleResource()) {
            String ppid = httpServletRequest.getParameter("p_p_id");
            if (!portletId.equals(ppid)) {
                return false;
            }
            String mvcResourceCommandName = httpServletRequest.getParameter("p_p_resource_id");
            return this._contains(portletId, this._portletInvocationWhitelistResource, mvcResourceCommandName);
        }
        return false;
    }

    @Override
    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String[] mvcActionCommandNames = this.getMVCActionCommandNames(liferayPortletURL);
        return this._containsAll(liferayPortletURL.getPortletId(), this._portletCSRFWhitelist, mvcActionCommandNames);
    }

    @Override
    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        String portletId = liferayPortletURL.getPortletId();
        String lifecycle = liferayPortletURL.getLifecycle();
        if (lifecycle.equals("ACTION_PHASE")) {
            String[] mvcActionCommandNames = this.getMVCActionCommandNames(liferayPortletURL);
            return this._containsAll(portletId, this._portletInvocationWhitelistAction, mvcActionCommandNames);
        }
        if (lifecycle.equals("RENDER_PHASE")) {
            String mvcRenderCommandName = liferayPortletURL.getParameter("mvcRenderCommandName");
            return this._contains(portletId, this._portletInvocationWhitelistRender, mvcRenderCommandName);
        }
        if (lifecycle.equals("RESOURCE_PHASE")) {
            String mvcResourceCommandName = liferayPortletURL.getResourceID();
            return this._contains(portletId, this._portletInvocationWhitelistResource, mvcResourceCommandName);
        }
        return false;
    }

    protected String[] getMVCActionCommandNames(HttpServletRequest httpServletRequest, String portletId) {
        String namespace = PortalUtil.getPortletNamespace(portletId);
        Object[] actionNames = httpServletRequest.getParameterValues(namespace.concat("javax.portlet.action"));
        String actions = StringUtil.merge(actionNames);
        return StringUtil.split(actions);
    }

    protected String[] getMVCActionCommandNames(LiferayPortletURL liferayPortletURL) {
        Map parameterMap = liferayPortletURL.getParameterMap();
        Object[] actionNames = (String[])parameterMap.get("javax.portlet.action");
        String actions = StringUtil.merge(actionNames);
        return StringUtil.split(actions);
    }

    protected String getWhitelistValue(String portletName, String whitelistAction) {
        return portletName.concat("#").concat(whitelistAction);
    }

    protected void trackWhitelistServices(String whitelistName, Class<?> serviceClass, Set<String> whiteList) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceTracker<Object, Object> serviceTracker = registry.trackServices(registry.getFilter(StringBundler.concat("(&(&(", whitelistName, "=*)(javax.portlet.name=*))", "(objectClass=", serviceClass.getName(), "))")), new TokenWhitelistTrackerCustomizer(whiteList));
        serviceTracker.open();
        this.serviceTrackers.add(serviceTracker);
    }

    private boolean _contains(String portletId, Set<String> whitelist, String item) {
        if (Validator.isBlank(item)) {
            return false;
        }
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        return whitelist.contains(this.getWhitelistValue(rootPortletId, item));
    }

    private boolean _containsAll(String portletId, Set<String> whitelist, String[] items) {
        if (items.length == 0) {
            return false;
        }
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        for (String action : items) {
            if (whitelist.contains(this.getWhitelistValue(rootPortletId, action))) continue;
            return false;
        }
        return true;
    }

    private class TokenWhitelistTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final Set<String> _whitelist;

        public TokenWhitelistTrackerCustomizer(Set<String> whitelist) {
            this._whitelist = whitelist;
        }

        @Override
        public Object addingService(ServiceReference<Object> serviceReference) {
            ArrayList<String> whitelistValues = new ArrayList<String>();
            List<String> whitelistActions = StringPlus.asList(serviceReference.getProperty("mvc.command.name"));
            List<String> portletNames = StringPlus.asList(serviceReference.getProperty("javax.portlet.name"));
            for (String portletName : portletNames) {
                for (String whitelistAction : whitelistActions) {
                    whitelistValues.add(MVCPortletAuthTokenWhitelist.this.getWhitelistValue(portletName, whitelistAction));
                }
            }
            this._whitelist.addAll(whitelistValues);
            return whitelistValues;
        }

        @Override
        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
            this.removedService(serviceReference, object);
            this.addingService(serviceReference);
        }

        @Override
        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            Collection whitelistValues = (Collection)object;
            this._whitelist.removeAll(whitelistValues);
        }
    }
}

