/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import java.util.Map;

@OSGiBeanProperties(property={"key=auth.max.failures"})
public class LoginMaxFailures
implements AuthFailure {
    @Override
    public void onFailureByEmailAddress(long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.updateLockoutByEmailAddress(companyId, emailAddress, true);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    @Override
    public void onFailureByScreenName(long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.updateLockoutByScreenName(companyId, screenName, true);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    @Override
    public void onFailureByUserId(long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.updateLockoutById(userId, true);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }
}

