/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import java.util.Map;

@OSGiBeanProperties(property={"key=auth.failure"})
public class LoginFailure
implements AuthFailure {
    @Override
    public void onFailureByEmailAddress(long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.checkLoginFailureByEmailAddress(companyId, emailAddress);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    @Override
    public void onFailureByScreenName(long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.checkLoginFailureByScreenName(companyId, screenName);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    @Override
    public void onFailureByUserId(long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            UserLocalServiceUtil.checkLoginFailureById(userId);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }
}

