/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenWhitelistImpl
extends BaseAuthTokenWhitelist {
    private final Set<String> _originCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> _portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());

    public AuthTokenWhitelistImpl() {
        this.trackWhitelistServices("auth.token.ignore.origins", this._originCSRFWhitelist);
        this.registerPortalProperty("auth.token.ignore.origins");
        this.trackWhitelistServices("auth.token.ignore.portlets", this._portletCSRFWhitelist);
        this.registerPortalProperty("auth.token.ignore.portlets");
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist", this._portletInvocationWhitelist);
        this.registerPortalProperty("portlet.add.default.resource.check.whitelist");
    }

    @Override
    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (String whitelistedOrigin : this._originCSRFWhitelist) {
            if (!origin.startsWith(whitelistedOrigin)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return this._portletCSRFWhitelist.contains(portlet.getRootPortletId());
    }

    @Override
    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return this._portletInvocationWhitelist.contains(portlet.getPortletId());
    }

    @Override
    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String rootPortletId = PortletIdCodec.decodePortletName(liferayPortletURL.getPortletId());
        return this._portletCSRFWhitelist.contains(rootPortletId);
    }

    @Override
    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        return this._portletInvocationWhitelist.contains(liferayPortletURL.getPortletId());
    }

    @Override
    public boolean isValidSharedSecret(String sharedSecret) {
        if (Validator.isNull(sharedSecret)) {
            return false;
        }
        if (Validator.isNull(PropsValues.AUTH_TOKEN_SHARED_SECRET)) {
            return false;
        }
        return sharedSecret.equals(DigesterUtil.digest(PropsValues.AUTH_TOKEN_SHARED_SECRET));
    }
}

