/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.security.auth.Authenticator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.List;
import java.util.Map;

public class AuthPipeline {
    private static final AuthPipeline _instance = new AuthPipeline();
    private final ServiceTrackerMap<String, List<Authenticator>> _authenticators = ServiceTrackerCollections.openMultiValueMap(Authenticator.class, "key");
    private final ServiceTrackerMap<String, List<AuthFailure>> _authFailures = ServiceTrackerCollections.openMultiValueMap(AuthFailure.class, "key");

    public static int authenticateByEmailAddress(String key, long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    public static int authenticateByScreenName(String key, long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    public static int authenticateByUserId(String key, long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    public static void onFailureByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, emailAddress, "emailAddress", headerMap, parameterMap);
    }

    public static void onFailureByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, screenName, "screenName", headerMap, parameterMap);
    }

    public static void onFailureByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, String.valueOf(userId), "userId", headerMap, parameterMap);
    }

    public static void onMaxFailuresByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByEmailAddress(key, companyId, emailAddress, headerMap, parameterMap);
    }

    public static void onMaxFailuresByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByScreenName(key, companyId, screenName, headerMap, parameterMap);
    }

    public static void onMaxFailuresByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByUserId(key, companyId, userId, headerMap, parameterMap);
    }

    private AuthPipeline() {
    }

    private int _authenticate(String key, long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        List<Authenticator> authenticators = this._authenticators.getService(key);
        if (ListUtil.isEmpty(authenticators)) {
            return 1;
        }
        boolean skipLiferayCheck = false;
        for (Authenticator authenticator : authenticators) {
            try {
                int authResult = -1;
                if (authType.equals("emailAddress")) {
                    authResult = authenticator.authenticateByEmailAddress(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    authResult = authenticator.authenticateByScreenName(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    long userId = GetterUtil.getLong(login);
                    authResult = authenticator.authenticateByUserId(companyId, userId, password, headerMap, parameterMap);
                }
                if (authResult == 2) {
                    skipLiferayCheck = true;
                    continue;
                }
                if (authResult == 1) continue;
                return authResult;
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException(e);
            }
        }
        if (skipLiferayCheck) {
            return 2;
        }
        return 1;
    }

    private void _onFailure(String key, long companyId, String login, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        List<AuthFailure> authFailures = this._authFailures.getService(key);
        if (authFailures.isEmpty()) {
            return;
        }
        for (AuthFailure authFailure : authFailures) {
            try {
                if (authType.equals("emailAddress")) {
                    authFailure.onFailureByEmailAddress(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (authType.equals("screenName")) {
                    authFailure.onFailureByScreenName(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (!authType.equals("userId")) continue;
                long userId = GetterUtil.getLong(login);
                authFailure.onFailureByUserId(companyId, userId, headerMap, parameterMap);
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException(e);
            }
        }
    }
}

