/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.access.control.BaseAccessControlPolicy;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AllowedHostsAccessControlPolicy
extends BaseAccessControlPolicy {
    @Override
    public void onServiceRemoteAccess(Method method, Object[] arguments, AccessControlled accessControlled) throws SecurityException {
        String hostsAllowedString;
        String[] hostsAllowed;
        Set<String> hostsAllowedSet;
        if (!accessControlled.hostAllowedValidationEnabled()) {
            return;
        }
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map<String, Object> settings = accessControlContext.getSettings();
        int serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth > 1) {
            return;
        }
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        if (!AccessControlUtil.isAccessAllowed(httpServletRequest, hostsAllowedSet = SetUtil.fromArray(hostsAllowed = StringUtil.split(hostsAllowedString = MapUtil.getString(accessControlContext.getSettings(), "hosts.allowed"))))) {
            throw new SecurityException("Access denied for " + httpServletRequest.getRemoteAddr());
        }
    }
}

