/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControl;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessControlImpl
implements AccessControl {
    @Override
    public void initAccessControlContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> settings) {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext != null) {
            throw new IllegalStateException("Authentication context is already initialized");
        }
        accessControlContext = new AccessControlContext();
        accessControlContext.setRequest(httpServletRequest);
        accessControlContext.setResponse(httpServletResponse);
        Map<String, Object> accessControlContextSettings = accessControlContext.getSettings();
        accessControlContextSettings.putAll(settings);
        AccessControlUtil.setAccessControlContext(accessControlContext);
    }

    @Override
    public void initContextUser(long userId) throws AuthException {
        try {
            User user = UserLocalServiceUtil.getUser(userId);
            CompanyThreadLocal.setCompanyId(user.getCompanyId());
            PrincipalThreadLocal.setName(userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
            AccessControlThreadLocal.setRemoteAccess(false);
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage(), e);
        }
    }

    @Override
    public AuthVerifierResult.State verifyRequest() throws PortalException {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = AuthVerifierPipeline.verifyRequest(accessControlContext);
        Map<String, Object> authVerifierResultSettings = authVerifierResult.getSettings();
        if (authVerifierResultSettings != null) {
            Map<String, Object> settings = accessControlContext.getSettings();
            settings.putAll(authVerifierResultSettings);
        }
        accessControlContext.setAuthVerifierResult(authVerifierResult);
        return authVerifierResult.getState();
    }
}

