/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.security.access.control.AccessControlAdvisorImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class AccessControlAdvice
extends ChainableMethodAdvice {
    private final AccessControlAdvisor _accessControlAdvisor = new AccessControlAdvisorImpl();

    @Override
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        return annotations.get(AccessControlled.class);
    }

    @Override
    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        this.incrementServiceDepth();
        AccessControlled accessControlled = (AccessControlled)aopMethodInvocation.getAdviceMethodContext();
        this._accessControlAdvisor.accept(aopMethodInvocation.getMethod(), arguments, accessControlled);
        return null;
    }

    protected void decrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map<String, Object> settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            return;
        }
        Integer n = serviceDepth;
        Integer n2 = serviceDepth = Integer.valueOf(serviceDepth - 1);
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }

    @Override
    protected void duringFinally(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        this.decrementServiceDepth();
    }

    protected void incrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map<String, Object> settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            serviceDepth = 1;
        } else {
            Integer n = serviceDepth;
            Integer n2 = serviceDepth = Integer.valueOf(serviceDepth + 1);
        }
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }
}

