/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.web.facet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.web.facet.BaseSearchFacet;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPSearchFacet
extends BaseSearchFacet {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPSearchFacet.class);
    private ServletContext _servletContext;

    public abstract String getConfigurationJspPath();

    public abstract String getDisplayJspPath();

    @Override
    public void includeConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (Validator.isNull(this.getConfigurationJspPath())) {
            return;
        }
        RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(this.getConfigurationJspPath());
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP " + this.getDisplayJspPath(), se);
            throw new IOException("Unable to include " + this.getDisplayJspPath(), se);
        }
    }

    @Override
    public void includeView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (Validator.isNull(this.getDisplayJspPath())) {
            return;
        }
        RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(this.getDisplayJspPath());
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP", se);
            throw new IOException("Unable to include " + this.getDisplayJspPath(), se);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }
}

