/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.stats;

import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.search.internal.stats.StatsRequestBuilderFactoryImpl;
import com.liferay.portal.search.internal.stats.StatsResponseBuilderImpl;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import com.liferay.portal.search.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.stats.StatsResponse;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatisticsTestCase
extends BaseIndexingTestCase {
    protected static final String STAT_FIELD = "priority";
    protected static final String STAT_SORTABLE_FIELD = "priority_Number_sortable";
    private final StatsRequestBuilderFactory _statsRequestBuilderFactory = new StatsRequestBuilderFactoryImpl();

    @Test
    public void testStats() throws Exception {
        this.addDocuments(31);
        final String field = STAT_SORTABLE_FIELD;
        Stats stats = new Stats(){
            {
                this.setCount(true);
                this.setField(field);
                this.setMax(true);
                this.setMean(true);
                this.setMin(true);
                this.setSum(true);
                this.setSumOfSquares(true);
            }
        };
        StatsResults expectedStatsResults = new StatsResults(field){
            {
                this.setCount(31L);
                this.setMax(31.0);
                this.setMean(16.0);
                this.setMin(1.0);
                this.setSum(496.0);
                this.setSumOfSquares(10416.0);
            }
        };
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.addStats(stats));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> {
                Map<String, StatsResults> statsResultsMap = hits.getStatsResults();
                Assert.assertNotNull(statsResultsMap);
                StatsResults statsResults = statsResultsMap.get(field);
                Assert.assertNotNull(statsResults);
                Assert.assertEquals(BaseStatisticsTestCase.toString(expectedStatsResults), BaseStatisticsTestCase.toString(statsResults));
            });
        });
    }

    @Test
    public void testStatsAgainstSearchCount() throws Exception {
        this.addDocuments(31);
        final String field = STAT_SORTABLE_FIELD;
        Stats stats = new Stats(){
            {
                this.setCount(true);
                this.setField(field);
            }
        };
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.addStats(stats));
            indexingTestHelper.searchCount();
            indexingTestHelper.verify(hits -> Assert.assertNull(hits));
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map<String, StatsResponse> map = searchResponse.getStatsResponseMap();
                Assert.assertTrue(map.isEmpty());
            });
        });
    }

    @Test
    public void testStatsRequest() throws Exception {
        this.addDocuments(31);
        String field = STAT_SORTABLE_FIELD;
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder();
        StatsRequest statsRequest = statsRequestBuilder.cardinality(true).count(true).field(field).max(true).mean(true).min(true).missing(true).sum(true).sumOfSquares(true).build();
        StatsResponseBuilderImpl statsResponseBuilder = new StatsResponseBuilderImpl();
        StatsResponse expectedStatsResponse = statsResponseBuilder.cardinality(31L).count(31L).field(field).max(31.0).mean(16.0).min(1.0).sum(496.0).sumOfSquares(10416.0).build();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequest -> searchRequest.statsRequests(statsRequest));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map<String, StatsResponse> map = searchResponse.getStatsResponseMap();
                Assert.assertNotNull(map);
                StatsResponse statsResponse = map.get(field);
                Assert.assertNotNull(statsResponse);
                Assert.assertEquals(BaseStatisticsTestCase.toString(expectedStatsResponse), BaseStatisticsTestCase.toString(statsResponse));
            });
        });
    }

    @Test
    public void testStatsRequestAgainstSearchCount() throws Exception {
        this.addDocuments(31);
        String field = STAT_SORTABLE_FIELD;
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder();
        StatsRequest statsRequest = statsRequestBuilder.cardinality(true).field(field).build();
        StatsResponseBuilderImpl statsResponseBuilder = new StatsResponseBuilderImpl();
        StatsResponse expectedStatsResponse = statsResponseBuilder.cardinality(31L).field(field).build();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.statsRequests(statsRequest));
            indexingTestHelper.searchCount();
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map<String, StatsResponse> map = searchResponse.getStatsResponseMap();
                Assert.assertNotNull(map);
                StatsResponse statsResponse = map.get(field);
                Assert.assertNotNull(statsResponse);
                Assert.assertEquals(BaseStatisticsTestCase.toString(expectedStatsResponse), BaseStatisticsTestCase.toString(statsResponse));
            });
        });
    }

    protected static String toString(final StatsResponse statsResponse) {
        return String.valueOf(new LinkedHashMap<String, Object>(){
            {
                this.put("cardinality", statsResponse.getCardinality());
                this.put("count", statsResponse.getCount());
                this.put("field", statsResponse.getField());
                this.put("max", statsResponse.getMax());
                this.put("mean", statsResponse.getMean());
                this.put("min", statsResponse.getMin());
                this.put("missing", statsResponse.getMissing());
                this.put("standardDeviation", statsResponse.getStandardDeviation());
                this.put("sum", statsResponse.getSum());
                this.put("sumOfSquares", statsResponse.getSumOfSquares());
            }
        });
    }

    protected static String toString(final StatsResults statsResults) {
        return String.valueOf(new LinkedHashMap<String, Object>(){
            {
                this.put("count", statsResults.getCount());
                this.put("field", statsResults.getField());
                this.put("max", statsResults.getMax());
                this.put("mean", statsResults.getMean());
                this.put("min", statsResults.getMin());
                this.put("missing", statsResults.getMissing());
                this.put("standardDeviation", statsResults.getStandardDeviation());
                this.put("sum", statsResults.getSum());
                this.put("sumOfSquares", statsResults.getSumOfSquares());
            }
        });
    }

    protected void addDocuments(int count) throws Exception {
        String field = STAT_FIELD;
        for (int i = 1; i <= count; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumberSortable(STAT_FIELD, i));
        }
    }
}

